package com.xforceplus.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_types
 * </p>
 *
 * @author ultraman
 * @since 2025-05-14
 */
public enum InvoiceTypes {

    S("s", "增值税专用发票"),
    C("c", "增值税普通发票"),
    SE("se", "增值税电子专用发票"),
    CE("ce", "增值税电子普通发票（含区块链）"),
    QC("qc", "全电增值税电子普通发票"),
    QS("qs", "全电增值税电子专用发票"),
    CZ("cz", "全电增值税纸质普通发票"),
    SZ("sz", "全电增值税纸质专用发票"),
    JU("ju", "增值税普通发票（卷票）"),
    V("v", "机动车统一销售发票"),
    CT("ct", "增值税电子普通发票（通行费）"),
    VS("vs", "二手车销售统一发票"),
    CP("cp", "海关缴款书"),
    CD("cd", "通用电子发票"),
    T("t", "火车票"),
    TAXI("taxi", "出租车票"),
    QUOTA("quota", "定额发票"),
    IM("im", "通用机打发票"),
    TOLL("toll", "过路费发票"),
    P("p", "飞机票"),
    BUS("bus", "客运公交票 "),
    OTHER("other", "其他发票"),
    CDF("cdf", "海关货物报关单"),
    FC("fc", "财政票据"),
    FCE("fce", "通用财政票据（电子）"),
    MOE("moe", "医疗门诊收费票据（电子）"),
    MHE("mhe", "医疗住院收费票据（电子）"),
    QT("qt", "电子发票（铁路电子客票）"),
    QP("qp", "电子发票（航空运输电子客票行程单）"),
    VZ("vz", "纸质发票（机动车销售统一发票）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceTypes(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceTypes fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "c":
                return C;
            case "se":
                return SE;
            case "ce":
                return CE;
            case "qc":
                return QC;
            case "qs":
                return QS;
            case "cz":
                return CZ;
            case "sz":
                return SZ;
            case "ju":
                return JU;
            case "v":
                return V;
            case "ct":
                return CT;
            case "vs":
                return VS;
            case "cp":
                return CP;
            case "cd":
                return CD;
            case "t":
                return T;
            case "taxi":
                return TAXI;
            case "quota":
                return QUOTA;
            case "im":
                return IM;
            case "toll":
                return TOLL;
            case "p":
                return P;
            case "bus":
                return BUS;
            case "other":
                return OTHER;
            case "cdf":
                return CDF;
            case "fc":
                return FC;
            case "fce":
                return FCE;
            case "moe":
                return MOE;
            case "mhe":
                return MHE;
            case "qt":
                return QT;
            case "qp":
                return QP;
            case "vz":
                return VZ;
            default:
                return null;
        }
    }
}
