package com.xforceplus.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * mapping_maintenance_status
 * </p>
 *
 * @author ultraman
 * @since 2025-05-14
 */
public enum MappingMaintenanceStatus {

    ERROR("Error", "异常"),
    TO_BE_MAINTAINED("ToBeMaintained", "待维护"),
    MAINTAINED("Maintained", "已维护");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MappingMaintenanceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MappingMaintenanceStatus fromCode(String code){
        switch(code) {
            case "Error":
                return ERROR;
            case "ToBeMaintained":
                return TO_BE_MAINTAINED;
            case "Maintained":
                return MAINTAINED;
            default:
                return null;
        }
    }
}
