package com.xforceplus.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * processing_status
 * </p>
 *
 * @author ultraman
 * @since 2025-05-14
 */
public enum ProcessingStatus {

    _1("1", "待处理"),
    _2("2", "处理中"),
    _3("3", "处理成功"),
    _4("4", "处理失败"),
    _0("0", "无需处理");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProcessingStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProcessingStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
