package com.xforceplus.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * send_control_status
 * </p>
 *
 * @author ultraman
 * @since 2024-08-13
 */
public enum SendControlStatus {

    UNSEND("Unsend", "未下发"),
    SEND("send", "已下发");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SendControlStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SendControlStatus fromCode(String code){
        switch(code) {
            case "Unsend":
                return UNSEND;
            case "send":
                return SEND;
            default:
                return null;
        }
    }
}
