package com.xforceplus.arterydocument.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-08-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TenantTransferRecord implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 来源单据摘要
   */
  @TableField("sourceDocDesc")
  private String sourceDocDesc;

  /**
   * 目标单据摘要
   */
  @TableField("targetDocDesc")
  private String targetDocDesc;

  /**
   * 租户单据转换状态
   */
  @TableField("transferStatus")
  private String transferStatus;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商名称
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 来源单据号
   */
  @TableField("sourceDocNo")
  private String sourceDocNo;

  /**
   * 转换时间
   */
  @TableField("transferTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime transferTime;

  /**
   * 来源单据版本号
   */
  @TableField("sourceDocVersion")
  private String sourceDocVersion;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 错误信息
   */
  @TableField("errorMessage")
  private String errorMessage;

  /**
   * 流日志ID
   */
  @TableField("flowLogID")
  private String flowLogID;

  /**
   * 流ID
   */
  @TableField("flowID")
  private String flowID;

  /**
   * 转换明细
   */
  @TableField("transferDetail")
  private String transferDetail;

  /**
   * sqsID
   */
  @TableField("sqsID")
  private String sqsID;

  /**
   * 扩展字段
   */
  private String ext1;

  /**
   * 来源单据类型
   */
  @TableField("sourceDocType")
  private String sourceDocType;

  /**
   * 目标单据类型
   */
  @TableField("targetDocType")
  private String targetDocType;

  /**
   * 购方门店编码
   */
  @TableField("purchaseStoreCode")
  private String purchaseStoreCode;

  /**
   * 购方门店名称
   */
  @TableField("purchaseStoreName")
  private String purchaseStoreName;

  /**
   * 销方编码
   */
  @TableField("sellerCode")
  private String sellerCode;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 业态编码
   */
  @TableField("purchaseBusinessTypeNo")
  private String purchaseBusinessTypeNo;

  /**
   * 业态名称
   */
  @TableField("purchaseBusinessTypeName")
  private String purchaseBusinessTypeName;

  /**
   * 区域编码
   */
  @TableField("regionCode")
  private String regionCode;

  /**
   * 区域名称
   */
  @TableField("regionName")
  private String regionName;

  /**
   * 商品编码
   */
  @TableField("itemCode")
  private String itemCode;

  /**
   * 商品名称
   */
  @TableField("itemDesc")
  private String itemDesc;

  /**
   * 租户单据检查状态
   */
  @TableField("pCheckStatus")
  private String pCheckStatus;

  /**
   * 单据检查标签
   */
  @TableField("pCheckTags")
  private String pCheckTags;

  /**
   * 转换次数
   */
  @TableField("transferNum")
  private Long transferNum;

  /**
   * 业务ID
   */
  @TableField("pBusinessId")
  private String pBusinessId;

  /**
   * 单据ID
   */
  @TableField("sourceDataId")
  private String sourceDataId;

  /**
   * 商超账号
   */
  @TableField("collectionAccount")
  private String collectionAccount;

  /**
   * 销售组织编码
   */
  @TableField("salesOrganizationCode")
  private String salesOrganizationCode;

  /**
   * 销售组织名称
   */
  @TableField("salesOrganizationName")
  private String salesOrganizationName;

  /**
   * 异常忽略标记
   */
  @TableField("exceptionIgnoreFlag")
  private Boolean exceptionIgnoreFlag;

  /**
   * 系统异常信息
   */
  @TableField("sysErrorMessage")
  private String sysErrorMessage;

  /**
   * 是否锁定
   */
  @TableField("lockFlag")
  private Boolean lockFlag;

  /**
   * 异常忽略原因
   */
  @TableField("exceptionIgnoreReason")
  private String exceptionIgnoreReason;

  /**
   * 订单日期
   */
  @TableField("poDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime poDate;

  /**
   * 订单截止日期
   */
  @TableField("deadlineDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deadlineDate;

  /**
   * 错误商品编码列表
   */
  @TableField("errorItemCodeList")
  private String errorItemCodeList;

  /**
   * 错误商品名称列表
   */
  @TableField("errorItemNameList")
  private String errorItemNameList;

  /**
   * 错误门店编码列表
   */
  @TableField("errorStoreCodeList")
  private String errorStoreCodeList;

  /**
   * 错误门店名称列表
   */
  @TableField("errorStoreNameList")
  private String errorStoreNameList;

  /**
   * 门店地址
   */
  @TableField("purchaseStoreAddress")
  private String purchaseStoreAddress;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("sourceDocDesc", sourceDocDesc);
      map.put("targetDocDesc", targetDocDesc);
      map.put("transferStatus", transferStatus);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("sourceDocNo", sourceDocNo);
      map.put("transferTime", BocpGenUtils.toTimestamp(transferTime));
      map.put("sourceDocVersion", sourceDocVersion);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("errorMessage", errorMessage);
      map.put("flowLogID", flowLogID);
      map.put("flowID", flowID);
      map.put("transferDetail", transferDetail);
      map.put("sqsID", sqsID);
      map.put("ext1", ext1);
      map.put("sourceDocType", sourceDocType);
      map.put("targetDocType", targetDocType);
      map.put("purchaseStoreCode", purchaseStoreCode);
      map.put("purchaseStoreName", purchaseStoreName);
      map.put("sellerCode", sellerCode);
      map.put("sellerName", sellerName);
      map.put("purchaseBusinessTypeNo", purchaseBusinessTypeNo);
      map.put("purchaseBusinessTypeName", purchaseBusinessTypeName);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("itemCode", itemCode);
      map.put("itemDesc", itemDesc);
      map.put("pCheckStatus", pCheckStatus);
      map.put("pCheckTags", pCheckTags);
      map.put("transferNum", transferNum);
      map.put("pBusinessId", pBusinessId);
      map.put("sourceDataId", sourceDataId);
      map.put("collectionAccount", collectionAccount);
      map.put("salesOrganizationCode", salesOrganizationCode);
      map.put("salesOrganizationName", salesOrganizationName);
      map.put("exceptionIgnoreFlag", exceptionIgnoreFlag);
      map.put("sysErrorMessage", sysErrorMessage);
      map.put("lockFlag", lockFlag);
      map.put("exceptionIgnoreReason", exceptionIgnoreReason);
      map.put("poDate", BocpGenUtils.toTimestamp(poDate));
      map.put("deadlineDate", BocpGenUtils.toTimestamp(deadlineDate));
      map.put("errorItemCodeList", errorItemCodeList);
      map.put("errorItemNameList", errorItemNameList);
      map.put("errorStoreCodeList", errorStoreCodeList);
      map.put("errorStoreNameList", errorStoreNameList);
      map.put("purchaseStoreAddress", purchaseStoreAddress);

      return map;
  }

  public static TenantTransferRecord fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TenantTransferRecord entity = new TenantTransferRecord();
    if(map.containsKey("sourceDocDesc")) {
      Object obj = map.get("sourceDocDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceDocDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("targetDocDesc")) {
      Object obj = map.get("targetDocDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTargetDocDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transferStatus")) {
      Object obj = map.get("transferStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransferStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sourceDocNo")) {
      Object obj = map.get("sourceDocNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceDocNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transferTime")) {
      Object obj = map.get("transferTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTransferTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTransferTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTransferTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTransferTime(null);
      }
    }
    if(map.containsKey("sourceDocVersion")) {
      Object obj = map.get("sourceDocVersion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceDocVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorMessage")) {
      Object obj = map.get("errorMessage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flowLogID")) {
      Object obj = map.get("flowLogID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlowLogID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flowID")) {
      Object obj = map.get("flowID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlowID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transferDetail")) {
      Object obj = map.get("transferDetail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransferDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sqsID")) {
      Object obj = map.get("sqsID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSqsID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sourceDocType")) {
      Object obj = map.get("sourceDocType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceDocType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("targetDocType")) {
      Object obj = map.get("targetDocType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTargetDocType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pCheckStatus")) {
      Object obj = map.get("pCheckStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pCheckTags")) {
      Object obj = map.get("pCheckTags");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPCheckTags((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transferNum")) {
      Object obj = map.get("transferNum");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTransferNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTransferNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTransferNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sourceDataId")) {
      Object obj = map.get("sourceDataId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceDataId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrganizationCode")) {
      Object obj = map.get("salesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrganizationName")) {
      Object obj = map.get("salesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exceptionIgnoreFlag")) {
      Object obj = map.get("exceptionIgnoreFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setExceptionIgnoreFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExceptionIgnoreFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("sysErrorMessage")) {
      Object obj = map.get("sysErrorMessage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSysErrorMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lockFlag")) {
      Object obj = map.get("lockFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLockFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLockFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("exceptionIgnoreReason")) {
      Object obj = map.get("exceptionIgnoreReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionIgnoreReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poDate")) {
      Object obj = map.get("poDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPoDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPoDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPoDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPoDate(null);
      }
    }
    if(map.containsKey("deadlineDate")) {
      Object obj = map.get("deadlineDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeadlineDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDeadlineDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeadlineDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeadlineDate(null);
      }
    }
    if(map.containsKey("errorItemCodeList")) {
      Object obj = map.get("errorItemCodeList");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorItemCodeList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorItemNameList")) {
      Object obj = map.get("errorItemNameList");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorItemNameList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorStoreCodeList")) {
      Object obj = map.get("errorStoreCodeList");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorStoreCodeList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorStoreNameList")) {
      Object obj = map.get("errorStoreNameList");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorStoreNameList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreAddress")) {
      Object obj = map.get("purchaseStoreAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreAddress((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("sourceDocDesc")) {
      Object obj = map.get("sourceDocDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceDocDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("targetDocDesc")) {
      Object obj = map.get("targetDocDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTargetDocDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transferStatus")) {
      Object obj = map.get("transferStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransferStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sourceDocNo")) {
      Object obj = map.get("sourceDocNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceDocNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transferTime")) {
      Object obj = map.get("transferTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTransferTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTransferTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTransferTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTransferTime(null);
      }
    }
    if(map.containsKey("sourceDocVersion")) {
      Object obj = map.get("sourceDocVersion");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceDocVersion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("errorMessage")) {
      Object obj = map.get("errorMessage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMessage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flowLogID")) {
      Object obj = map.get("flowLogID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlowLogID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flowID")) {
      Object obj = map.get("flowID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlowID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transferDetail")) {
      Object obj = map.get("transferDetail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransferDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sqsID")) {
      Object obj = map.get("sqsID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSqsID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sourceDocType")) {
      Object obj = map.get("sourceDocType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceDocType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("targetDocType")) {
      Object obj = map.get("targetDocType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTargetDocType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseBusinessTypeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseBusinessTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pCheckStatus")) {
      Object obj = map.get("pCheckStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pCheckTags")) {
      Object obj = map.get("pCheckTags");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPCheckTags((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transferNum")) {
      Object obj = map.get("transferNum");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTransferNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTransferNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTransferNum(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sourceDataId")) {
      Object obj = map.get("sourceDataId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceDataId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesOrganizationCode")) {
      Object obj = map.get("salesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesOrganizationCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesOrganizationName")) {
      Object obj = map.get("salesOrganizationName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesOrganizationName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exceptionIgnoreFlag")) {
      Object obj = map.get("exceptionIgnoreFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setExceptionIgnoreFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExceptionIgnoreFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("sysErrorMessage")) {
      Object obj = map.get("sysErrorMessage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSysErrorMessage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lockFlag")) {
      Object obj = map.get("lockFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLockFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLockFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("exceptionIgnoreReason")) {
      Object obj = map.get("exceptionIgnoreReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionIgnoreReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("poDate")) {
      Object obj = map.get("poDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPoDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPoDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPoDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPoDate(null);
      }
    }
    if(map.containsKey("deadlineDate")) {
      Object obj = map.get("deadlineDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeadlineDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDeadlineDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeadlineDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDeadlineDate(null);
      }
    }
    if(map.containsKey("errorItemCodeList")) {
      Object obj = map.get("errorItemCodeList");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorItemCodeList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("errorItemNameList")) {
      Object obj = map.get("errorItemNameList");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorItemNameList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("errorStoreCodeList")) {
      Object obj = map.get("errorStoreCodeList");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorStoreCodeList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("errorStoreNameList")) {
      Object obj = map.get("errorStoreNameList");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorStoreNameList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreAddress")) {
      Object obj = map.get("purchaseStoreAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreAddress((String)obj);
        }
      } else {
      }
    }
  }
}
