package com.xforceplus.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-01-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillingDetailDiscount implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * billing单编号
   */
  @TableField("billingNo")
  private String billingNo;

  /**
   * billing单行编号
   */
  @TableField("billingLineNo")
  private String billingLineNo;

  /**
   * billing折扣行号
   */
  @TableField("billingDiscountLineNo")
  private String billingDiscountLineNo;

  /**
   * 折扣类型
   */
  @TableField("discountType")
  private String discountType;

  /**
   * 折扣类型描述
   */
  @TableField("discountTypeDesc")
  private String discountTypeDesc;

  /**
   * 折扣单位
   */
  @TableField("discountUnit")
  private String discountUnit;

  /**
   * 折扣金额
   */
  @TableField("discountAmt")
  private BigDecimal discountAmt;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 金额合并类型
   */
  @TableField("amountMergeType")
  private String amountMergeType;


  /**
   * 对一关联关系 关联对象 billingDetail
   */
    private Long detailIdId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("billingNo", billingNo);
      map.put("billingLineNo", billingLineNo);
      map.put("billingDiscountLineNo", billingDiscountLineNo);
      map.put("discountType", discountType);
      map.put("discountTypeDesc", discountTypeDesc);
      map.put("discountUnit", discountUnit);
      map.put("discountAmt", discountAmt);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("amountMergeType", amountMergeType);

       map.put("detailId.id", detailIdId);
      return map;
  }

  public static BillingDetailDiscount fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillingDetailDiscount entity = new BillingDetailDiscount();
    if(map.containsKey("billingNo")) {
      Object obj = map.get("billingNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingLineNo")) {
      Object obj = map.get("billingLineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingDiscountLineNo")) {
      Object obj = map.get("billingDiscountLineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingDiscountLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountType")) {
      Object obj = map.get("discountType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiscountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountTypeDesc")) {
      Object obj = map.get("discountTypeDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiscountTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountUnit")) {
      Object obj = map.get("discountUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiscountUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountAmt")) {
      Object obj = map.get("discountAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountMergeType")) {
      Object obj = map.get("amountMergeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountMergeType((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("detailId.id")) {
        Object obj = map.get("detailId.id");
      if(obj instanceof Long) {
        entity.setDetailIdId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setDetailIdId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("billingNo")) {
      Object obj = map.get("billingNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingLineNo")) {
      Object obj = map.get("billingLineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingLineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingDiscountLineNo")) {
      Object obj = map.get("billingDiscountLineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingDiscountLineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discountType")) {
      Object obj = map.get("discountType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiscountType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discountTypeDesc")) {
      Object obj = map.get("discountTypeDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiscountTypeDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discountUnit")) {
      Object obj = map.get("discountUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiscountUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discountAmt")) {
      Object obj = map.get("discountAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountMergeType")) {
      Object obj = map.get("amountMergeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountMergeType((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("detailId.id")) {
        Object obj = map.get("detailId.id");
        if(obj instanceof Long) {
          this.setDetailIdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDetailIdId(Long.parseLong((String)obj));
        }
      }
  }
}
