package com.xforceplus.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * expense_detail_source_type
 * </p>
 *
 * @author ultraman
 * @since 2024-01-09
 */
public enum ExpenseDetailSourceType {

    EXPENSE_SETTLEMENT_DETAIL("expenseSettlementDetail", "费用单"),
    SETTLEMENT_BILL("settlementBill", "结算单"),
    PAYMENT("payment", "付款单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ExpenseDetailSourceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExpenseDetailSourceType fromCode(String code){
        switch(code) {
            case "expenseSettlementDetail":
                return EXPENSE_SETTLEMENT_DETAIL;
            case "settlementBill":
                return SETTLEMENT_BILL;
            case "payment":
                return PAYMENT;
            default:
                return null;
        }
    }
}
