package com.xforceplus.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-01-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Billing implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 所属租户
   */
  @TableField("belongTenant")
  private String belongTenant;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商描述
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * billing单编号
   */
  @TableField("billingNo")
  private String billingNo;

  /**
   * 单据类型
   */
  @TableField("billingType")
  private String billingType;

  /**
   * 单据日期
   */
  @TableField("billingDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billingDate;

  /**
   * 创建日期
   */
  @TableField("creationDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime creationDate;

  /**
   * 更新日期
   */
  @TableField("updateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateDate;

  /**
   * 关联红字通知单号
   */
  @TableField("refRedIVNoticeNo")
  private String refRedIVNoticeNo;

  /**
   * 关联凭证编号
   */
  @TableField("refDocumentNo")
  private String refDocumentNo;

  /**
   * 关联采购订单ID
   */
  @TableField("refPOId")
  private String refPOId;

  /**
   * 关联采购订单编号
   */
  @TableField("refPONo")
  private String refPONo;

  /**
   * 关联购方结算单ID
   */
  @TableField("refPurchaseSettlementId")
  private String refPurchaseSettlementId;

  /**
   * 关联购方结算单号
   */
  @TableField("refPurchaseSettlementNo")
  private String refPurchaseSettlementNo;

  /**
   * 单据状态
   */
  @TableField("billingStatus")
  private String billingStatus;

  /**
   * 取消标识
   */
  @TableField("cancelFlag")
  private BigDecimal cancelFlag;

  /**
   * 销方类型
   */
  @TableField("sellerType")
  private String sellerType;

  /**
   * 销方统一社会信用代码
   */
  @TableField("sellerCompanyTaxNo")
  private String sellerCompanyTaxNo;

  /**
   * 销方公司编码
   */
  @TableField("sellerCompanyCode")
  private String sellerCompanyCode;

  /**
   * 销方公司名称
   */
  @TableField("sellerCompanyName")
  private String sellerCompanyName;

  /**
   * 销方编码
   */
  @TableField("sellerCode")
  private String sellerCode;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销售组织编码
   */
  @TableField("salesOrganizationCode")
  private String salesOrganizationCode;

  /**
   * 销售组织名称
   */
  @TableField("salesOrganizationName")
  private String salesOrganizationName;

  /**
   * 销售组编码
   */
  @TableField("salesGroupCode")
  private String salesGroupCode;

  /**
   * 销售组名称
   */
  @TableField("salesGroupName")
  private String salesGroupName;

  /**
   * 客户类型
   */
  @TableField("customerType")
  private String customerType;

  /**
   * 客户编码
   */
  @TableField("customerCode")
  private String customerCode;

  /**
   * 客户名称
   */
  @TableField("customerName")
  private String customerName;

  /**
   * 客户组
   */
  @TableField("customerGroup")
  private String customerGroup;

  /**
   * 客户联系电话
   */
  @TableField("customerPhone")
  private String customerPhone;

  /**
   * 客户地址
   */
  @TableField("customerAddress")
  private String customerAddress;

  /**
   * 付款方编码
   */
  @TableField("payToCode")
  private String payToCode;

  /**
   * 付款方名称
   */
  @TableField("payToName")
  private String payToName;

  /**
   * 送达方编码
   */
  @TableField("shipToCode")
  private String shipToCode;

  /**
   * 送达方名称
   */
  @TableField("shipToName")
  private String shipToName;

  /**
   * 收票方公司编码
   */
  @TableField("billToCode")
  private String billToCode;

  /**
   * 收票方公司名称
   */
  @TableField("billToName")
  private String billToName;

  /**
   * 收票方统一社会信用代码
   */
  @TableField("billToCompanyTaxNo")
  private String billToCompanyTaxNo;

  /**
   * 总金额（含税）
   */
  @TableField("totalAmt")
  private BigDecimal totalAmt;

  /**
   * 总金额（不含税）
   */
  @TableField("totalAmtWithoutTax")
  private BigDecimal totalAmtWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmt")
  private BigDecimal taxAmt;

  /**
   * 开票金额（含税）
   */
  @TableField("invoiceAmtWithTax")
  private BigDecimal invoiceAmtWithTax;

  /**
   * 开票金额（不含税）
   */
  @TableField("invoiceAmtWithoutTax")
  private BigDecimal invoiceAmtWithoutTax;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 开票类型
   */
  @TableField("issuingInvoiceType")
  private String issuingInvoiceType;

  /**
   * 不开票原因
   */
  @TableField("noInvoiceReason")
  private String noInvoiceReason;

  /**
   * 购方银行账号
   */
  @TableField("purchaserBankAccount")
  private String purchaserBankAccount;

  /**
   * 购方银行名称
   */
  @TableField("purchaserBankName")
  private String purchaserBankName;

  /**
   * 发票日期
   */
  @TableField("invoiceDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceDate;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 币种
   */
  private String currency;

  /**
   * 汇率日期
   */
  @TableField("exRateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime exRateDate;

  /**
   * 汇率
   */
  @TableField("exRate")
  private BigDecimal exRate;

  /**
   * 汇率类型
   */
  @TableField("exRateType")
  private String exRateType;

  /**
   * 备注
   */
  private String remark;

  /**
   * 自定义字段1
   */
  private String attribute1;

  /**
   * 自定义字段2
   */
  private String attribute2;

  /**
   * 自定义字段3
   */
  private String attribute3;

  /**
   * 自定义字段4
   */
  private String attribute4;

  /**
   * 自定义字段5
   */
  private String attribute5;

  /**
   * 自定义字段6
   */
  private String attribute6;

  /**
   * 自定义字段7
   */
  private String attribute7;

  /**
   * 自定义字段8
   */
  private String attribute8;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 是否是最新版本
   */
  private Boolean latest;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;

  /**
   * 业务Id
   */
  @TableField("pBusinessId")
  private String pBusinessId;

  /**
   * 销方开票状态
   */
  @TableField("pSellerInvoiceStatus")
  private String pSellerInvoiceStatus;

  /**
   * 特殊收票方编码
   */
  @TableField("specialBillToCode")
  private String specialBillToCode;

  /**
   * 国税发票来源
   */
  @TableField("taxInvoiceSource")
  private String taxInvoiceSource;

  /**
   * 不开票原因描述
   */
  @TableField("noInvoiceReasonDesc")
  private String noInvoiceReasonDesc;

  /**
   * 销方对账状态
   */
  @TableField("pSellerReconStatus")
  private String pSellerReconStatus;

  /**
   * 价内折扣金额（不含税）
   */
  @TableField("inPriceDiscountWithoutTax")
  private BigDecimal inPriceDiscountWithoutTax;

  /**
   * 价内折扣金额（含税）
   */
  @TableField("inPriceDiscountWithTax")
  private BigDecimal inPriceDiscountWithTax;

  /**
   * 价外折扣金额（不含税）
   */
  @TableField("offPriceDiscountWithoutTax")
  private BigDecimal offPriceDiscountWithoutTax;

  /**
   * 价外折扣金额（含税）
   */
  @TableField("offPriceDiscountWithTax")
  private BigDecimal offPriceDiscountWithTax;

  /**
   * 不开票标识
   */
  @TableField("noInvoiceStatus")
  private String noInvoiceStatus;

  /**
   * businessId
   */
  @TableField("businessId")
  private Long businessId;

  /**
   * billing关联购方结算单绑定状态
   */
  @TableField("refSettlementBindingStatus")
  private String refSettlementBindingStatus;

  /**
   * 平台冲销类型
   */
  @TableField("pWriteOffType")
  private String pWriteOffType;

  /**
   * 平台冲销状态
   */
  @TableField("pWriteOffStatus")
  private String pWriteOffStatus;

  /**
   * 平台冲销原因
   */
  @TableField("pWriteOffReason")
  private String pWriteOffReason;

  /**
   * 被冲销billing单号
   */
  @TableField("pWriteOffBillingNo")
  private String pWriteOffBillingNo;

  /**
   * 平台单据类型
   */
  @TableField("pBillingType")
  private String pBillingType;

  /**
   * 接收电票邮箱
   */
  @TableField("receiveUserEmail")
  private String receiveUserEmail;

  /**
   * 红票标记
   */
  @TableField("redInvoiceFlag")
  private String redInvoiceFlag;

  /**
   * 价格方式
   */
  @TableField("priceStatus")
  private Long priceStatus;

  /**
   * 开票税额
   */
  @TableField("invoiceTaxAmt")
  private BigDecimal invoiceTaxAmt;

  /**
   * 总金额1(含税)
   */
  @TableField("totalAmt1WithTax")
  private BigDecimal totalAmt1WithTax;

  /**
   * 总金额1(不含税)
   */
  @TableField("totalAmt1WithoutTax")
  private BigDecimal totalAmt1WithoutTax;

  /**
   * 总金额2(含税)
   */
  @TableField("totalAmt2WithTax")
  private BigDecimal totalAmt2WithTax;

  /**
   * 总金额2(不含税)
   */
  @TableField("totalAmt2WithoutTax")
  private BigDecimal totalAmt2WithoutTax;

  /**
   * 总金额3(含税)
   */
  @TableField("totalAmt3WithTax")
  private BigDecimal totalAmt3WithTax;

  /**
   * 总金额3(不含税)
   */
  @TableField("totalAmt3WithoutTax")
  private BigDecimal totalAmt3WithoutTax;

  /**
   * 总金额4(含税)
   */
  @TableField("totalAmt4WithTax")
  private BigDecimal totalAmt4WithTax;

  /**
   * 总金额4(不含税)
   */
  @TableField("totalAmt4WithoutTax")
  private BigDecimal totalAmt4WithoutTax;

  /**
   * 总金额5(含税)
   */
  @TableField("totalAmt5WithTax")
  private BigDecimal totalAmt5WithTax;

  /**
   * 总金额5(不含税)
   */
  @TableField("totalAmt5WithoutTax")
  private BigDecimal totalAmt5WithoutTax;

  /**
   * 系统采购订单编号
   */
  @TableField("sysPONo")
  private String sysPONo;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("belongTenant", belongTenant);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("billingNo", billingNo);
      map.put("billingType", billingType);
      map.put("billingDate", BocpGenUtils.toTimestamp(billingDate));
      map.put("creationDate", BocpGenUtils.toTimestamp(creationDate));
      map.put("updateDate", BocpGenUtils.toTimestamp(updateDate));
      map.put("refRedIVNoticeNo", refRedIVNoticeNo);
      map.put("refDocumentNo", refDocumentNo);
      map.put("refPOId", refPOId);
      map.put("refPONo", refPONo);
      map.put("refPurchaseSettlementId", refPurchaseSettlementId);
      map.put("refPurchaseSettlementNo", refPurchaseSettlementNo);
      map.put("billingStatus", billingStatus);
      map.put("cancelFlag", cancelFlag);
      map.put("sellerType", sellerType);
      map.put("sellerCompanyTaxNo", sellerCompanyTaxNo);
      map.put("sellerCompanyCode", sellerCompanyCode);
      map.put("sellerCompanyName", sellerCompanyName);
      map.put("sellerCode", sellerCode);
      map.put("sellerName", sellerName);
      map.put("salesOrganizationCode", salesOrganizationCode);
      map.put("salesOrganizationName", salesOrganizationName);
      map.put("salesGroupCode", salesGroupCode);
      map.put("salesGroupName", salesGroupName);
      map.put("customerType", customerType);
      map.put("customerCode", customerCode);
      map.put("customerName", customerName);
      map.put("customerGroup", customerGroup);
      map.put("customerPhone", customerPhone);
      map.put("customerAddress", customerAddress);
      map.put("payToCode", payToCode);
      map.put("payToName", payToName);
      map.put("shipToCode", shipToCode);
      map.put("shipToName", shipToName);
      map.put("billToCode", billToCode);
      map.put("billToName", billToName);
      map.put("billToCompanyTaxNo", billToCompanyTaxNo);
      map.put("totalAmt", totalAmt);
      map.put("totalAmtWithoutTax", totalAmtWithoutTax);
      map.put("taxAmt", taxAmt);
      map.put("invoiceAmtWithTax", invoiceAmtWithTax);
      map.put("invoiceAmtWithoutTax", invoiceAmtWithoutTax);
      map.put("invoiceType", invoiceType);
      map.put("issuingInvoiceType", issuingInvoiceType);
      map.put("noInvoiceReason", noInvoiceReason);
      map.put("purchaserBankAccount", purchaserBankAccount);
      map.put("purchaserBankName", purchaserBankName);
      map.put("invoiceDate", BocpGenUtils.toTimestamp(invoiceDate));
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("currency", currency);
      map.put("exRateDate", BocpGenUtils.toTimestamp(exRateDate));
      map.put("exRate", exRate);
      map.put("exRateType", exRateType);
      map.put("remark", remark);
      map.put("attribute1", attribute1);
      map.put("attribute2", attribute2);
      map.put("attribute3", attribute3);
      map.put("attribute4", attribute4);
      map.put("attribute5", attribute5);
      map.put("attribute6", attribute6);
      map.put("attribute7", attribute7);
      map.put("attribute8", attribute8);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("latest", latest);
      map.put("versionNo", versionNo);
      map.put("pBusinessId", pBusinessId);
      map.put("pSellerInvoiceStatus", pSellerInvoiceStatus);
      map.put("specialBillToCode", specialBillToCode);
      map.put("taxInvoiceSource", taxInvoiceSource);
      map.put("noInvoiceReasonDesc", noInvoiceReasonDesc);
      map.put("pSellerReconStatus", pSellerReconStatus);
      map.put("inPriceDiscountWithoutTax", inPriceDiscountWithoutTax);
      map.put("inPriceDiscountWithTax", inPriceDiscountWithTax);
      map.put("offPriceDiscountWithoutTax", offPriceDiscountWithoutTax);
      map.put("offPriceDiscountWithTax", offPriceDiscountWithTax);
      map.put("noInvoiceStatus", noInvoiceStatus);
      map.put("businessId", businessId);
      map.put("refSettlementBindingStatus", refSettlementBindingStatus);
      map.put("pWriteOffType", pWriteOffType);
      map.put("pWriteOffStatus", pWriteOffStatus);
      map.put("pWriteOffReason", pWriteOffReason);
      map.put("pWriteOffBillingNo", pWriteOffBillingNo);
      map.put("pBillingType", pBillingType);
      map.put("receiveUserEmail", receiveUserEmail);
      map.put("redInvoiceFlag", redInvoiceFlag);
      map.put("priceStatus", priceStatus);
      map.put("invoiceTaxAmt", invoiceTaxAmt);
      map.put("totalAmt1WithTax", totalAmt1WithTax);
      map.put("totalAmt1WithoutTax", totalAmt1WithoutTax);
      map.put("totalAmt2WithTax", totalAmt2WithTax);
      map.put("totalAmt2WithoutTax", totalAmt2WithoutTax);
      map.put("totalAmt3WithTax", totalAmt3WithTax);
      map.put("totalAmt3WithoutTax", totalAmt3WithoutTax);
      map.put("totalAmt4WithTax", totalAmt4WithTax);
      map.put("totalAmt4WithoutTax", totalAmt4WithoutTax);
      map.put("totalAmt5WithTax", totalAmt5WithTax);
      map.put("totalAmt5WithoutTax", totalAmt5WithoutTax);
      map.put("sysPONo", sysPONo);

      return map;
  }

  public static Billing fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Billing entity = new Billing();
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingNo")) {
      Object obj = map.get("billingNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingDate")) {
      Object obj = map.get("billingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBillingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillingDate(null);
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreationDate(null);
      }
    }
    if(map.containsKey("updateDate")) {
      Object obj = map.get("updateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateDate(null);
      }
    }
    if(map.containsKey("refRedIVNoticeNo")) {
      Object obj = map.get("refRedIVNoticeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefRedIVNoticeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refDocumentNo")) {
      Object obj = map.get("refDocumentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPOId")) {
      Object obj = map.get("refPOId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefPOId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPONo")) {
      Object obj = map.get("refPONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPurchaseSettlementId")) {
      Object obj = map.get("refPurchaseSettlementId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefPurchaseSettlementId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPurchaseSettlementNo")) {
      Object obj = map.get("refPurchaseSettlementNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefPurchaseSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingStatus")) {
      Object obj = map.get("billingStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cancelFlag")) {
      Object obj = map.get("cancelFlag");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCancelFlag((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCancelFlag(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCancelFlag(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCancelFlag(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCancelFlag(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sellerType")) {
      Object obj = map.get("sellerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrganizationCode")) {
      Object obj = map.get("salesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrganizationName")) {
      Object obj = map.get("salesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesGroupCode")) {
      Object obj = map.get("salesGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesGroupName")) {
      Object obj = map.get("salesGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerType")) {
      Object obj = map.get("customerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerCode")) {
      Object obj = map.get("customerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerGroup")) {
      Object obj = map.get("customerGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerPhone")) {
      Object obj = map.get("customerPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerAddress")) {
      Object obj = map.get("customerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payToCode")) {
      Object obj = map.get("payToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payToName")) {
      Object obj = map.get("payToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToCode")) {
      Object obj = map.get("shipToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToName")) {
      Object obj = map.get("shipToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billToCode")) {
      Object obj = map.get("billToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billToName")) {
      Object obj = map.get("billToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billToCompanyTaxNo")) {
      Object obj = map.get("billToCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillToCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt")) {
      Object obj = map.get("totalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmt")) {
      Object obj = map.get("taxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmtWithTax")) {
      Object obj = map.get("invoiceAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmtWithoutTax")) {
      Object obj = map.get("invoiceAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issuingInvoiceType")) {
      Object obj = map.get("issuingInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIssuingInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("noInvoiceReason")) {
      Object obj = map.get("noInvoiceReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNoInvoiceReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceDate(null);
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exRateDate")) {
      Object obj = map.get("exRateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExRateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExRateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExRateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExRateDate(null);
      }
    }
    if(map.containsKey("exRate")) {
      Object obj = map.get("exRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("exRateType")) {
      Object obj = map.get("exRateType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExRateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute1")) {
      Object obj = map.get("attribute1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute2")) {
      Object obj = map.get("attribute2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute3")) {
      Object obj = map.get("attribute3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute4")) {
      Object obj = map.get("attribute4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute5")) {
      Object obj = map.get("attribute5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute6")) {
      Object obj = map.get("attribute6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute7")) {
      Object obj = map.get("attribute7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute8")) {
      Object obj = map.get("attribute8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerInvoiceStatus")) {
      Object obj = map.get("pSellerInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSellerInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialBillToCode")) {
      Object obj = map.get("specialBillToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialBillToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("noInvoiceReasonDesc")) {
      Object obj = map.get("noInvoiceReasonDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNoInvoiceReasonDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerReconStatus")) {
      Object obj = map.get("pSellerReconStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSellerReconStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inPriceDiscountWithoutTax")) {
      Object obj = map.get("inPriceDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInPriceDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInPriceDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInPriceDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInPriceDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInPriceDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("inPriceDiscountWithTax")) {
      Object obj = map.get("inPriceDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInPriceDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInPriceDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInPriceDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInPriceDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInPriceDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("offPriceDiscountWithoutTax")) {
      Object obj = map.get("offPriceDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOffPriceDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOffPriceDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOffPriceDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOffPriceDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOffPriceDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("offPriceDiscountWithTax")) {
      Object obj = map.get("offPriceDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOffPriceDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOffPriceDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOffPriceDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOffPriceDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOffPriceDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("noInvoiceStatus")) {
      Object obj = map.get("noInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNoInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("refSettlementBindingStatus")) {
      Object obj = map.get("refSettlementBindingStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefSettlementBindingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pWriteOffType")) {
      Object obj = map.get("pWriteOffType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPWriteOffType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pWriteOffStatus")) {
      Object obj = map.get("pWriteOffStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPWriteOffStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pWriteOffReason")) {
      Object obj = map.get("pWriteOffReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPWriteOffReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pWriteOffBillingNo")) {
      Object obj = map.get("pWriteOffBillingNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPWriteOffBillingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBillingType")) {
      Object obj = map.get("pBillingType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBillingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redInvoiceFlag")) {
      Object obj = map.get("redInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPriceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPriceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPriceStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceTaxAmt")) {
      Object obj = map.get("invoiceTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt1WithTax")) {
      Object obj = map.get("totalAmt1WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt1WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt1WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt1WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt1WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt1WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt1WithoutTax")) {
      Object obj = map.get("totalAmt1WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt1WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt1WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt1WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt1WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt1WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt2WithTax")) {
      Object obj = map.get("totalAmt2WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt2WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt2WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt2WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt2WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt2WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt2WithoutTax")) {
      Object obj = map.get("totalAmt2WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt2WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt2WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt2WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt2WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt2WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt3WithTax")) {
      Object obj = map.get("totalAmt3WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt3WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt3WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt3WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt3WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt3WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt3WithoutTax")) {
      Object obj = map.get("totalAmt3WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt3WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt3WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt3WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt3WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt3WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt4WithTax")) {
      Object obj = map.get("totalAmt4WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt4WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt4WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt4WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt4WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt4WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt4WithoutTax")) {
      Object obj = map.get("totalAmt4WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt4WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt4WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt4WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt4WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt4WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt5WithTax")) {
      Object obj = map.get("totalAmt5WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt5WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt5WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt5WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt5WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt5WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt5WithoutTax")) {
      Object obj = map.get("totalAmt5WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt5WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt5WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt5WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt5WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt5WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sysPONo")) {
      Object obj = map.get("sysPONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSysPONo((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingNo")) {
      Object obj = map.get("billingNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingDate")) {
      Object obj = map.get("billingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBillingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBillingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBillingDate(null);
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreationDate(null);
      }
    }
    if(map.containsKey("updateDate")) {
      Object obj = map.get("updateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateDate(null);
      }
    }
    if(map.containsKey("refRedIVNoticeNo")) {
      Object obj = map.get("refRedIVNoticeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefRedIVNoticeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refDocumentNo")) {
      Object obj = map.get("refDocumentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefDocumentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refPOId")) {
      Object obj = map.get("refPOId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefPOId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refPONo")) {
      Object obj = map.get("refPONo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefPONo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refPurchaseSettlementId")) {
      Object obj = map.get("refPurchaseSettlementId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefPurchaseSettlementId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refPurchaseSettlementNo")) {
      Object obj = map.get("refPurchaseSettlementNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefPurchaseSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingStatus")) {
      Object obj = map.get("billingStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cancelFlag")) {
      Object obj = map.get("cancelFlag");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCancelFlag((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCancelFlag(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCancelFlag(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCancelFlag(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCancelFlag(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sellerType")) {
      Object obj = map.get("sellerType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesOrganizationCode")) {
      Object obj = map.get("salesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesOrganizationCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesOrganizationName")) {
      Object obj = map.get("salesOrganizationName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesOrganizationName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesGroupCode")) {
      Object obj = map.get("salesGroupCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesGroupCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesGroupName")) {
      Object obj = map.get("salesGroupName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesGroupName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerType")) {
      Object obj = map.get("customerType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerCode")) {
      Object obj = map.get("customerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerGroup")) {
      Object obj = map.get("customerGroup");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerPhone")) {
      Object obj = map.get("customerPhone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerAddress")) {
      Object obj = map.get("customerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payToCode")) {
      Object obj = map.get("payToCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayToCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payToName")) {
      Object obj = map.get("payToName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayToName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipToCode")) {
      Object obj = map.get("shipToCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipToCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipToName")) {
      Object obj = map.get("shipToName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipToName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billToCode")) {
      Object obj = map.get("billToCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillToCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billToName")) {
      Object obj = map.get("billToName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillToName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billToCompanyTaxNo")) {
      Object obj = map.get("billToCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillToCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("totalAmt")) {
      Object obj = map.get("totalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmt")) {
      Object obj = map.get("taxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceAmtWithTax")) {
      Object obj = map.get("invoiceAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceAmtWithoutTax")) {
      Object obj = map.get("invoiceAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issuingInvoiceType")) {
      Object obj = map.get("issuingInvoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIssuingInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("noInvoiceReason")) {
      Object obj = map.get("noInvoiceReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNoInvoiceReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInvoiceDate(null);
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCurrency((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exRateDate")) {
      Object obj = map.get("exRateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExRateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExRateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExRateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExRateDate(null);
      }
    }
    if(map.containsKey("exRate")) {
      Object obj = map.get("exRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("exRateType")) {
      Object obj = map.get("exRateType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExRateType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute1")) {
      Object obj = map.get("attribute1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute2")) {
      Object obj = map.get("attribute2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute3")) {
      Object obj = map.get("attribute3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute4")) {
      Object obj = map.get("attribute4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute5")) {
      Object obj = map.get("attribute5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute6")) {
      Object obj = map.get("attribute6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute7")) {
      Object obj = map.get("attribute7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute8")) {
      Object obj = map.get("attribute8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pSellerInvoiceStatus")) {
      Object obj = map.get("pSellerInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSellerInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specialBillToCode")) {
      Object obj = map.get("specialBillToCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialBillToCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxInvoiceSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("noInvoiceReasonDesc")) {
      Object obj = map.get("noInvoiceReasonDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNoInvoiceReasonDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pSellerReconStatus")) {
      Object obj = map.get("pSellerReconStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSellerReconStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inPriceDiscountWithoutTax")) {
      Object obj = map.get("inPriceDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInPriceDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInPriceDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInPriceDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInPriceDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInPriceDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("inPriceDiscountWithTax")) {
      Object obj = map.get("inPriceDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInPriceDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInPriceDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInPriceDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInPriceDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInPriceDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("offPriceDiscountWithoutTax")) {
      Object obj = map.get("offPriceDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOffPriceDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOffPriceDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOffPriceDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOffPriceDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOffPriceDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("offPriceDiscountWithTax")) {
      Object obj = map.get("offPriceDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOffPriceDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOffPriceDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOffPriceDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOffPriceDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOffPriceDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("noInvoiceStatus")) {
      Object obj = map.get("noInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNoInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("refSettlementBindingStatus")) {
      Object obj = map.get("refSettlementBindingStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefSettlementBindingStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pWriteOffType")) {
      Object obj = map.get("pWriteOffType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPWriteOffType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pWriteOffStatus")) {
      Object obj = map.get("pWriteOffStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPWriteOffStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pWriteOffReason")) {
      Object obj = map.get("pWriteOffReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPWriteOffReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pWriteOffBillingNo")) {
      Object obj = map.get("pWriteOffBillingNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPWriteOffBillingNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pBillingType")) {
      Object obj = map.get("pBillingType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBillingType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveUserEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redInvoiceFlag")) {
      Object obj = map.get("redInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedInvoiceFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPriceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPriceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPriceStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceTaxAmt")) {
      Object obj = map.get("invoiceTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmt1WithTax")) {
      Object obj = map.get("totalAmt1WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmt1WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmt1WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmt1WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmt1WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmt1WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmt1WithoutTax")) {
      Object obj = map.get("totalAmt1WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmt1WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmt1WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmt1WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmt1WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmt1WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmt2WithTax")) {
      Object obj = map.get("totalAmt2WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmt2WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmt2WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmt2WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmt2WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmt2WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmt2WithoutTax")) {
      Object obj = map.get("totalAmt2WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmt2WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmt2WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmt2WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmt2WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmt2WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmt3WithTax")) {
      Object obj = map.get("totalAmt3WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmt3WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmt3WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmt3WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmt3WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmt3WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmt3WithoutTax")) {
      Object obj = map.get("totalAmt3WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmt3WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmt3WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmt3WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmt3WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmt3WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmt4WithTax")) {
      Object obj = map.get("totalAmt4WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmt4WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmt4WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmt4WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmt4WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmt4WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmt4WithoutTax")) {
      Object obj = map.get("totalAmt4WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmt4WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmt4WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmt4WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmt4WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmt4WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmt5WithTax")) {
      Object obj = map.get("totalAmt5WithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmt5WithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmt5WithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmt5WithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmt5WithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmt5WithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmt5WithoutTax")) {
      Object obj = map.get("totalAmt5WithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmt5WithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmt5WithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmt5WithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmt5WithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmt5WithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sysPONo")) {
      Object obj = map.get("sysPONo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSysPONo((String)obj);
        }
      } else {
      }
    }
  }
}
