package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.Inventory;
import com.xforceplus.arterydocument.service.IInventoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-15
 */
@RestController
public class InventoryController {

  @Autowired
  private IInventoryService inventoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param inventory ${table.comment}
   * @return
   */
  @GetMapping("/inventorys" )
  public XfR getInventorys(XfPage page, Inventory inventory) {
    return XfR.ok(inventoryServiceImpl.page(page, Wrappers.query(inventory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/inventorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(inventoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param inventory ${table.comment}
   * @return XfR
   */
  @PostMapping("/inventorys")
  public XfR save(@RequestBody Inventory inventory) {
     return XfR.ok(inventoryServiceImpl.save(inventory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param inventory ${table.comment}
   * @return XfR
   */
  @PutMapping("/inventorys/{id}")
  public XfR putUpdate(@RequestBody Inventory inventory,@PathVariable Long id) {
      inventory.setId(id);
      return XfR.ok(inventoryServiceImpl.updateById(inventory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param inventory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/inventorys/{id}")
  public XfR patchUpdate(@RequestBody Inventory inventory,@PathVariable Long id) {
      Inventory upinventory = inventoryServiceImpl.getById(id);
      if(upinventory != null){
        upinventory = ObjectCopyUtils.copyProperties(inventory,upinventory,true);
      }
      return XfR.ok(inventoryServiceImpl.updateById(upinventory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/inventorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(inventoryServiceImpl.removeById(id));
  }

  @PostMapping("/inventorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inventory");
     params.put("request", condition);

     return XfR.ok(inventoryServiceImpl.querys(params));
  }

}
