package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.InvoiceSettlementDetail;
import com.xforceplus.arterydocument.service.IInvoiceSettlementDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-15
 */
@RestController
public class InvoiceSettlementDetailController {

  @Autowired
  private IInvoiceSettlementDetailService invoiceSettlementDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceSettlementDetail ${table.comment}
   * @return
   */
  @GetMapping("/invoicesettlementdetails" )
  public XfR getInvoiceSettlementDetails(XfPage page, InvoiceSettlementDetail invoiceSettlementDetail) {
    return XfR.ok(invoiceSettlementDetailServiceImpl.page(page, Wrappers.query(invoiceSettlementDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicesettlementdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceSettlementDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceSettlementDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicesettlementdetails")
  public XfR save(@RequestBody InvoiceSettlementDetail invoiceSettlementDetail) {
     return XfR.ok(invoiceSettlementDetailServiceImpl.save(invoiceSettlementDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceSettlementDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicesettlementdetails/{id}")
  public XfR putUpdate(@RequestBody InvoiceSettlementDetail invoiceSettlementDetail,@PathVariable Long id) {
      invoiceSettlementDetail.setId(id);
      return XfR.ok(invoiceSettlementDetailServiceImpl.updateById(invoiceSettlementDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceSettlementDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicesettlementdetails/{id}")
  public XfR patchUpdate(@RequestBody InvoiceSettlementDetail invoiceSettlementDetail,@PathVariable Long id) {
      InvoiceSettlementDetail upinvoiceSettlementDetail = invoiceSettlementDetailServiceImpl.getById(id);
      if(upinvoiceSettlementDetail != null){
        upinvoiceSettlementDetail = ObjectCopyUtils.copyProperties(invoiceSettlementDetail,upinvoiceSettlementDetail,true);
      }
      return XfR.ok(invoiceSettlementDetailServiceImpl.updateById(upinvoiceSettlementDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicesettlementdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceSettlementDetailServiceImpl.removeById(id));
  }

  @PostMapping("/invoicesettlementdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_settlement_detail");
     params.put("request", condition);

     return XfR.ok(invoiceSettlementDetailServiceImpl.querys(params));
  }

}
