package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.SettlementAccountDeductionDetail;
import com.xforceplus.arterydocument.service.ISettlementAccountDeductionDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-02-22
 */
@RestController
public class SettlementAccountDeductionDetailController {

  @Autowired
  private ISettlementAccountDeductionDetailService settlementAccountDeductionDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementAccountDeductionDetail ${table.comment}
   * @return
   */
  @GetMapping("/settlementaccountdeductiondetails" )
  public XfR getSettlementAccountDeductionDetails(XfPage page, SettlementAccountDeductionDetail settlementAccountDeductionDetail) {
    return XfR.ok(settlementAccountDeductionDetailServiceImpl.page(page, Wrappers.query(settlementAccountDeductionDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementaccountdeductiondetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementAccountDeductionDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param settlementAccountDeductionDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/settlementaccountdeductiondetails")
  public XfR save(@RequestBody SettlementAccountDeductionDetail settlementAccountDeductionDetail) {
     return XfR.ok(settlementAccountDeductionDetailServiceImpl.save(settlementAccountDeductionDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param settlementAccountDeductionDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/settlementaccountdeductiondetails/{id}")
  public XfR putUpdate(@RequestBody SettlementAccountDeductionDetail settlementAccountDeductionDetail,@PathVariable Long id) {
      settlementAccountDeductionDetail.setId(id);
      return XfR.ok(settlementAccountDeductionDetailServiceImpl.updateById(settlementAccountDeductionDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param settlementAccountDeductionDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/settlementaccountdeductiondetails/{id}")
  public XfR patchUpdate(@RequestBody SettlementAccountDeductionDetail settlementAccountDeductionDetail,@PathVariable Long id) {
      SettlementAccountDeductionDetail upsettlementAccountDeductionDetail = settlementAccountDeductionDetailServiceImpl.getById(id);
      if(upsettlementAccountDeductionDetail != null){
        upsettlementAccountDeductionDetail = ObjectCopyUtils.copyProperties(settlementAccountDeductionDetail,upsettlementAccountDeductionDetail,true);
      }
      return XfR.ok(settlementAccountDeductionDetailServiceImpl.updateById(upsettlementAccountDeductionDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementaccountdeductiondetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementAccountDeductionDetailServiceImpl.removeById(id));
  }

  @PostMapping("/settlementaccountdeductiondetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_account_deduction_detail");
     params.put("request", condition);

     return XfR.ok(settlementAccountDeductionDetailServiceImpl.querys(params));
  }

}
