package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.SettlementInvoiceDeductionDetail;
import com.xforceplus.arterydocument.service.ISettlementInvoiceDeductionDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-01
 */
@RestController
public class SettlementInvoiceDeductionDetailController {

  @Autowired
  private ISettlementInvoiceDeductionDetailService settlementInvoiceDeductionDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementInvoiceDeductionDetail ${table.comment}
   * @return
   */
  @GetMapping("/settlementinvoicedeductiondetails" )
  public XfR getSettlementInvoiceDeductionDetails(XfPage page, SettlementInvoiceDeductionDetail settlementInvoiceDeductionDetail) {
    return XfR.ok(settlementInvoiceDeductionDetailServiceImpl.page(page, Wrappers.query(settlementInvoiceDeductionDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementinvoicedeductiondetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementInvoiceDeductionDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param settlementInvoiceDeductionDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/settlementinvoicedeductiondetails")
  public XfR save(@RequestBody SettlementInvoiceDeductionDetail settlementInvoiceDeductionDetail) {
     return XfR.ok(settlementInvoiceDeductionDetailServiceImpl.save(settlementInvoiceDeductionDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param settlementInvoiceDeductionDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/settlementinvoicedeductiondetails/{id}")
  public XfR putUpdate(@RequestBody SettlementInvoiceDeductionDetail settlementInvoiceDeductionDetail,@PathVariable Long id) {
      settlementInvoiceDeductionDetail.setId(id);
      return XfR.ok(settlementInvoiceDeductionDetailServiceImpl.updateById(settlementInvoiceDeductionDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param settlementInvoiceDeductionDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/settlementinvoicedeductiondetails/{id}")
  public XfR patchUpdate(@RequestBody SettlementInvoiceDeductionDetail settlementInvoiceDeductionDetail,@PathVariable Long id) {
      SettlementInvoiceDeductionDetail upsettlementInvoiceDeductionDetail = settlementInvoiceDeductionDetailServiceImpl.getById(id);
      if(upsettlementInvoiceDeductionDetail != null){
        upsettlementInvoiceDeductionDetail = ObjectCopyUtils.copyProperties(settlementInvoiceDeductionDetail,upsettlementInvoiceDeductionDetail,true);
      }
      return XfR.ok(settlementInvoiceDeductionDetailServiceImpl.updateById(upsettlementInvoiceDeductionDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementinvoicedeductiondetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementInvoiceDeductionDetailServiceImpl.removeById(id));
  }

  @PostMapping("/settlementinvoicedeductiondetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_invoice_deduction_detail");
     params.put("request", condition);

     return XfR.ok(settlementInvoiceDeductionDetailServiceImpl.querys(params));
  }

}
