package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.BillingDetail;
import com.xforceplus.arterydocument.service.IBillingDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-22
 */
@RestController
public class BillingDetailController {

  @Autowired
  private IBillingDetailService billingDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billingDetail ${table.comment}
   * @return
   */
  @GetMapping("/billingdetails" )
  public XfR getBillingDetails(XfPage page, BillingDetail billingDetail) {
    return XfR.ok(billingDetailServiceImpl.page(page, Wrappers.query(billingDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billingdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billingDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billingDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/billingdetails")
  public XfR save(@RequestBody BillingDetail billingDetail) {
     return XfR.ok(billingDetailServiceImpl.save(billingDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billingDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/billingdetails/{id}")
  public XfR putUpdate(@RequestBody BillingDetail billingDetail,@PathVariable Long id) {
      billingDetail.setId(id);
      return XfR.ok(billingDetailServiceImpl.updateById(billingDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billingDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billingdetails/{id}")
  public XfR patchUpdate(@RequestBody BillingDetail billingDetail,@PathVariable Long id) {
      BillingDetail upbillingDetail = billingDetailServiceImpl.getById(id);
      if(upbillingDetail != null){
        upbillingDetail = ObjectCopyUtils.copyProperties(billingDetail,upbillingDetail,true);
      }
      return XfR.ok(billingDetailServiceImpl.updateById(upbillingDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billingdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billingDetailServiceImpl.removeById(id));
  }

  @PostMapping("/billingdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "billing_detail");
     params.put("request", condition);

     return XfR.ok(billingDetailServiceImpl.querys(params));
  }

}
