package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.ExpenseBill;
import com.xforceplus.arterydocument.service.IExpenseBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-28
 */
@RestController
public class ExpenseBillController {

  @Autowired
  private IExpenseBillService expenseBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param expenseBill ${table.comment}
   * @return
   */
  @GetMapping("/expensebills" )
  public XfR getExpenseBills(XfPage page, ExpenseBill expenseBill) {
    return XfR.ok(expenseBillServiceImpl.page(page, Wrappers.query(expenseBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/expensebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(expenseBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param expenseBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/expensebills")
  public XfR save(@RequestBody ExpenseBill expenseBill) {
     return XfR.ok(expenseBillServiceImpl.save(expenseBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param expenseBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/expensebills/{id}")
  public XfR putUpdate(@RequestBody ExpenseBill expenseBill,@PathVariable Long id) {
      expenseBill.setId(id);
      return XfR.ok(expenseBillServiceImpl.updateById(expenseBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param expenseBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/expensebills/{id}")
  public XfR patchUpdate(@RequestBody ExpenseBill expenseBill,@PathVariable Long id) {
      ExpenseBill upexpenseBill = expenseBillServiceImpl.getById(id);
      if(upexpenseBill != null){
        upexpenseBill = ObjectCopyUtils.copyProperties(expenseBill,upexpenseBill,true);
      }
      return XfR.ok(expenseBillServiceImpl.updateById(upexpenseBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/expensebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(expenseBillServiceImpl.removeById(id));
  }

  @PostMapping("/expensebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "expense_bill");
     params.put("request", condition);

     return XfR.ok(expenseBillServiceImpl.querys(params));
  }

}
