package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.GoodsReceiveNote;
import com.xforceplus.arterydocument.service.IGoodsReceiveNoteService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-28
 */
@RestController
public class GoodsReceiveNoteController {

  @Autowired
  private IGoodsReceiveNoteService goodsReceiveNoteServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param goodsReceiveNote ${table.comment}
   * @return
   */
  @GetMapping("/goodsreceivenotes" )
  public XfR getGoodsReceiveNotes(XfPage page, GoodsReceiveNote goodsReceiveNote) {
    return XfR.ok(goodsReceiveNoteServiceImpl.page(page, Wrappers.query(goodsReceiveNote)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/goodsreceivenotes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(goodsReceiveNoteServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param goodsReceiveNote ${table.comment}
   * @return XfR
   */
  @PostMapping("/goodsreceivenotes")
  public XfR save(@RequestBody GoodsReceiveNote goodsReceiveNote) {
     return XfR.ok(goodsReceiveNoteServiceImpl.save(goodsReceiveNote));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param goodsReceiveNote ${table.comment}
   * @return XfR
   */
  @PutMapping("/goodsreceivenotes/{id}")
  public XfR putUpdate(@RequestBody GoodsReceiveNote goodsReceiveNote,@PathVariable Long id) {
      goodsReceiveNote.setId(id);
      return XfR.ok(goodsReceiveNoteServiceImpl.updateById(goodsReceiveNote));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param goodsReceiveNote ${table.comment}
   * @return XfR
   */
  @PatchMapping("/goodsreceivenotes/{id}")
  public XfR patchUpdate(@RequestBody GoodsReceiveNote goodsReceiveNote,@PathVariable Long id) {
      GoodsReceiveNote upgoodsReceiveNote = goodsReceiveNoteServiceImpl.getById(id);
      if(upgoodsReceiveNote != null){
        upgoodsReceiveNote = ObjectCopyUtils.copyProperties(goodsReceiveNote,upgoodsReceiveNote,true);
      }
      return XfR.ok(goodsReceiveNoteServiceImpl.updateById(upgoodsReceiveNote));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/goodsreceivenotes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(goodsReceiveNoteServiceImpl.removeById(id));
  }

  @PostMapping("/goodsreceivenotes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "goods_receive_note");
     params.put("request", condition);

     return XfR.ok(goodsReceiveNoteServiceImpl.querys(params));
  }

}
