package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.PointOfSale;
import com.xforceplus.arterydocument.service.IPointOfSaleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-28
 */
@RestController
public class PointOfSaleController {

  @Autowired
  private IPointOfSaleService pointOfSaleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pointOfSale ${table.comment}
   * @return
   */
  @GetMapping("/pointofsales" )
  public XfR getPointOfSales(XfPage page, PointOfSale pointOfSale) {
    return XfR.ok(pointOfSaleServiceImpl.page(page, Wrappers.query(pointOfSale)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/pointofsales/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(pointOfSaleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param pointOfSale ${table.comment}
   * @return XfR
   */
  @PostMapping("/pointofsales")
  public XfR save(@RequestBody PointOfSale pointOfSale) {
     return XfR.ok(pointOfSaleServiceImpl.save(pointOfSale));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param pointOfSale ${table.comment}
   * @return XfR
   */
  @PutMapping("/pointofsales/{id}")
  public XfR putUpdate(@RequestBody PointOfSale pointOfSale,@PathVariable Long id) {
      pointOfSale.setId(id);
      return XfR.ok(pointOfSaleServiceImpl.updateById(pointOfSale));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param pointOfSale ${table.comment}
   * @return XfR
   */
  @PatchMapping("/pointofsales/{id}")
  public XfR patchUpdate(@RequestBody PointOfSale pointOfSale,@PathVariable Long id) {
      PointOfSale uppointOfSale = pointOfSaleServiceImpl.getById(id);
      if(uppointOfSale != null){
        uppointOfSale = ObjectCopyUtils.copyProperties(pointOfSale,uppointOfSale,true);
      }
      return XfR.ok(pointOfSaleServiceImpl.updateById(uppointOfSale));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pointofsales/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(pointOfSaleServiceImpl.removeById(id));
  }

  @PostMapping("/pointofsales/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "point_of_sale");
     params.put("request", condition);

     return XfR.ok(pointOfSaleServiceImpl.querys(params));
  }

}
