package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.BillingDetailDiscount;
import com.xforceplus.arterydocument.service.IBillingDetailDiscountService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-04
 */
@RestController
public class BillingDetailDiscountController {

  @Autowired
  private IBillingDetailDiscountService billingDetailDiscountServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billingDetailDiscount ${table.comment}
   * @return
   */
  @GetMapping("/billingdetaildiscounts" )
  public XfR getBillingDetailDiscounts(XfPage page, BillingDetailDiscount billingDetailDiscount) {
    return XfR.ok(billingDetailDiscountServiceImpl.page(page, Wrappers.query(billingDetailDiscount)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billingdetaildiscounts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billingDetailDiscountServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billingDetailDiscount ${table.comment}
   * @return XfR
   */
  @PostMapping("/billingdetaildiscounts")
  public XfR save(@RequestBody BillingDetailDiscount billingDetailDiscount) {
     return XfR.ok(billingDetailDiscountServiceImpl.save(billingDetailDiscount));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billingDetailDiscount ${table.comment}
   * @return XfR
   */
  @PutMapping("/billingdetaildiscounts/{id}")
  public XfR putUpdate(@RequestBody BillingDetailDiscount billingDetailDiscount,@PathVariable Long id) {
      billingDetailDiscount.setId(id);
      return XfR.ok(billingDetailDiscountServiceImpl.updateById(billingDetailDiscount));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billingDetailDiscount ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billingdetaildiscounts/{id}")
  public XfR patchUpdate(@RequestBody BillingDetailDiscount billingDetailDiscount,@PathVariable Long id) {
      BillingDetailDiscount upbillingDetailDiscount = billingDetailDiscountServiceImpl.getById(id);
      if(upbillingDetailDiscount != null){
        upbillingDetailDiscount = ObjectCopyUtils.copyProperties(billingDetailDiscount,upbillingDetailDiscount,true);
      }
      return XfR.ok(billingDetailDiscountServiceImpl.updateById(upbillingDetailDiscount));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billingdetaildiscounts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billingDetailDiscountServiceImpl.removeById(id));
  }

  @PostMapping("/billingdetaildiscounts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "billing_detail_discount");
     params.put("request", condition);

     return XfR.ok(billingDetailDiscountServiceImpl.querys(params));
  }

}
