package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.SettlementBill;
import com.xforceplus.arterydocument.service.ISettlementBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-08
 */
@RestController
public class SettlementBillController {

  @Autowired
  private ISettlementBillService settlementBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementBill ${table.comment}
   * @return
   */
  @GetMapping("/settlementbills" )
  public XfR getSettlementBills(XfPage page, SettlementBill settlementBill) {
    return XfR.ok(settlementBillServiceImpl.page(page, Wrappers.query(settlementBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param settlementBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/settlementbills")
  public XfR save(@RequestBody SettlementBill settlementBill) {
     return XfR.ok(settlementBillServiceImpl.save(settlementBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param settlementBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/settlementbills/{id}")
  public XfR putUpdate(@RequestBody SettlementBill settlementBill,@PathVariable Long id) {
      settlementBill.setId(id);
      return XfR.ok(settlementBillServiceImpl.updateById(settlementBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param settlementBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/settlementbills/{id}")
  public XfR patchUpdate(@RequestBody SettlementBill settlementBill,@PathVariable Long id) {
      SettlementBill upsettlementBill = settlementBillServiceImpl.getById(id);
      if(upsettlementBill != null){
        upsettlementBill = ObjectCopyUtils.copyProperties(settlementBill,upsettlementBill,true);
      }
      return XfR.ok(settlementBillServiceImpl.updateById(upsettlementBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementBillServiceImpl.removeById(id));
  }

  @PostMapping("/settlementbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_bill");
     params.put("request", condition);

     return XfR.ok(settlementBillServiceImpl.querys(params));
  }

}
