package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.MeituanPreferredProducts;
import com.xforceplus.arterydocument.service.IMeituanPreferredProductsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-11
 */
@RestController
public class MeituanPreferredProductsController {

  @Autowired
  private IMeituanPreferredProductsService meituanPreferredProductsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param meituanPreferredProducts ${table.comment}
   * @return
   */
  @GetMapping("/meituanpreferredproductss" )
  public XfR getMeituanPreferredProductss(XfPage page, MeituanPreferredProducts meituanPreferredProducts) {
    return XfR.ok(meituanPreferredProductsServiceImpl.page(page, Wrappers.query(meituanPreferredProducts)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/meituanpreferredproductss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(meituanPreferredProductsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param meituanPreferredProducts ${table.comment}
   * @return XfR
   */
  @PostMapping("/meituanpreferredproductss")
  public XfR save(@RequestBody MeituanPreferredProducts meituanPreferredProducts) {
     return XfR.ok(meituanPreferredProductsServiceImpl.save(meituanPreferredProducts));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param meituanPreferredProducts ${table.comment}
   * @return XfR
   */
  @PutMapping("/meituanpreferredproductss/{id}")
  public XfR putUpdate(@RequestBody MeituanPreferredProducts meituanPreferredProducts,@PathVariable Long id) {
      meituanPreferredProducts.setId(id);
      return XfR.ok(meituanPreferredProductsServiceImpl.updateById(meituanPreferredProducts));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param meituanPreferredProducts ${table.comment}
   * @return XfR
   */
  @PatchMapping("/meituanpreferredproductss/{id}")
  public XfR patchUpdate(@RequestBody MeituanPreferredProducts meituanPreferredProducts,@PathVariable Long id) {
      MeituanPreferredProducts upmeituanPreferredProducts = meituanPreferredProductsServiceImpl.getById(id);
      if(upmeituanPreferredProducts != null){
        upmeituanPreferredProducts = ObjectCopyUtils.copyProperties(meituanPreferredProducts,upmeituanPreferredProducts,true);
      }
      return XfR.ok(meituanPreferredProductsServiceImpl.updateById(upmeituanPreferredProducts));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/meituanpreferredproductss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(meituanPreferredProductsServiceImpl.removeById(id));
  }

  @PostMapping("/meituanpreferredproductss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "meituan_preferred_products");
     params.put("request", condition);

     return XfR.ok(meituanPreferredProductsServiceImpl.querys(params));
  }

}
