package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.SettlementDocRefGRNRTV;
import com.xforceplus.arterydocument.service.ISettlementDocRefGRNRTVService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * V2前端控制器
 *
 * @author ultraman
 * @date 2024-05-11
 */
@RestController
public class SettlementDocRefGRNRTVController {

  @Autowired
  private ISettlementDocRefGRNRTVService settlementDocRefGRNRTVServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementDocRefGRNRTV V2
   * @return
   */
  @GetMapping("/settlementdocrefgrnrtvs" )
  public XfR getSettlementDocRefGRNRTVs(XfPage page, SettlementDocRefGRNRTV settlementDocRefGRNRTV) {
    return XfR.ok(settlementDocRefGRNRTVServiceImpl.page(page, Wrappers.query(settlementDocRefGRNRTV)));
  }

  /**
   * 通过id查询V2
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementdocrefgrnrtvs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementDocRefGRNRTVServiceImpl.getById(id));
  }

  /**
   * 新增V2
   * @param settlementDocRefGRNRTV V2
   * @return XfR
   */
  @PostMapping("/settlementdocrefgrnrtvs")
  public XfR save(@RequestBody SettlementDocRefGRNRTV settlementDocRefGRNRTV) {
     return XfR.ok(settlementDocRefGRNRTVServiceImpl.save(settlementDocRefGRNRTV));
  }

  /**
   * 修改-传入修改后的全部数据V2
   * @param settlementDocRefGRNRTV V2
   * @return XfR
   */
  @PutMapping("/settlementdocrefgrnrtvs/{id}")
  public XfR putUpdate(@RequestBody SettlementDocRefGRNRTV settlementDocRefGRNRTV,@PathVariable Long id) {
      settlementDocRefGRNRTV.setId(id);
      return XfR.ok(settlementDocRefGRNRTVServiceImpl.updateById(settlementDocRefGRNRTV));
  }

  /**
   * 修改-传入修改的数据V2
   * @param settlementDocRefGRNRTV V2
   * @return XfR
   */
  @PatchMapping("/settlementdocrefgrnrtvs/{id}")
  public XfR patchUpdate(@RequestBody SettlementDocRefGRNRTV settlementDocRefGRNRTV,@PathVariable Long id) {
      SettlementDocRefGRNRTV upsettlementDocRefGRNRTV = settlementDocRefGRNRTVServiceImpl.getById(id);
      if(upsettlementDocRefGRNRTV != null){
        upsettlementDocRefGRNRTV = ObjectCopyUtils.copyProperties(settlementDocRefGRNRTV,upsettlementDocRefGRNRTV,true);
      }
      return XfR.ok(settlementDocRefGRNRTVServiceImpl.updateById(upsettlementDocRefGRNRTV));
  }

  /**
   * 通过id删除V2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementdocrefgrnrtvs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementDocRefGRNRTVServiceImpl.removeById(id));
  }

  @PostMapping("/settlementdocrefgrnrtvs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_doc_ref_g_r_n_r_t_v");
     params.put("request", condition);

     return XfR.ok(settlementDocRefGRNRTVServiceImpl.querys(params));
  }

}
