package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.SysTypeMapping;
import com.xforceplus.arterydocument.service.ISysTypeMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-13
 */
@RestController
public class SysTypeMappingController {

  @Autowired
  private ISysTypeMappingService sysTypeMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sysTypeMapping ${table.comment}
   * @return
   */
  @GetMapping("/systypemappings" )
  public XfR getSysTypeMappings(XfPage page, SysTypeMapping sysTypeMapping) {
    return XfR.ok(sysTypeMappingServiceImpl.page(page, Wrappers.query(sysTypeMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/systypemappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sysTypeMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sysTypeMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/systypemappings")
  public XfR save(@RequestBody SysTypeMapping sysTypeMapping) {
     return XfR.ok(sysTypeMappingServiceImpl.save(sysTypeMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sysTypeMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/systypemappings/{id}")
  public XfR putUpdate(@RequestBody SysTypeMapping sysTypeMapping,@PathVariable Long id) {
      sysTypeMapping.setId(id);
      return XfR.ok(sysTypeMappingServiceImpl.updateById(sysTypeMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sysTypeMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/systypemappings/{id}")
  public XfR patchUpdate(@RequestBody SysTypeMapping sysTypeMapping,@PathVariable Long id) {
      SysTypeMapping upsysTypeMapping = sysTypeMappingServiceImpl.getById(id);
      if(upsysTypeMapping != null){
        upsysTypeMapping = ObjectCopyUtils.copyProperties(sysTypeMapping,upsysTypeMapping,true);
      }
      return XfR.ok(sysTypeMappingServiceImpl.updateById(upsysTypeMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systypemappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sysTypeMappingServiceImpl.removeById(id));
  }

  @PostMapping("/systypemappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sys_type_mapping");
     params.put("request", condition);

     return XfR.ok(sysTypeMappingServiceImpl.querys(params));
  }

}
