package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.TenantSalesOrderStoreDetail;
import com.xforceplus.arterydocument.service.ITenantSalesOrderStoreDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-13
 */
@RestController
public class TenantSalesOrderStoreDetailController {

  @Autowired
  private ITenantSalesOrderStoreDetailService tenantSalesOrderStoreDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tenantSalesOrderStoreDetail ${table.comment}
   * @return
   */
  @GetMapping("/tenantsalesorderstoredetails" )
  public XfR getTenantSalesOrderStoreDetails(XfPage page, TenantSalesOrderStoreDetail tenantSalesOrderStoreDetail) {
    return XfR.ok(tenantSalesOrderStoreDetailServiceImpl.page(page, Wrappers.query(tenantSalesOrderStoreDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tenantsalesorderstoredetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tenantSalesOrderStoreDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tenantSalesOrderStoreDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/tenantsalesorderstoredetails")
  public XfR save(@RequestBody TenantSalesOrderStoreDetail tenantSalesOrderStoreDetail) {
     return XfR.ok(tenantSalesOrderStoreDetailServiceImpl.save(tenantSalesOrderStoreDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tenantSalesOrderStoreDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/tenantsalesorderstoredetails/{id}")
  public XfR putUpdate(@RequestBody TenantSalesOrderStoreDetail tenantSalesOrderStoreDetail,@PathVariable Long id) {
      tenantSalesOrderStoreDetail.setId(id);
      return XfR.ok(tenantSalesOrderStoreDetailServiceImpl.updateById(tenantSalesOrderStoreDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tenantSalesOrderStoreDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tenantsalesorderstoredetails/{id}")
  public XfR patchUpdate(@RequestBody TenantSalesOrderStoreDetail tenantSalesOrderStoreDetail,@PathVariable Long id) {
      TenantSalesOrderStoreDetail uptenantSalesOrderStoreDetail = tenantSalesOrderStoreDetailServiceImpl.getById(id);
      if(uptenantSalesOrderStoreDetail != null){
        uptenantSalesOrderStoreDetail = ObjectCopyUtils.copyProperties(tenantSalesOrderStoreDetail,uptenantSalesOrderStoreDetail,true);
      }
      return XfR.ok(tenantSalesOrderStoreDetailServiceImpl.updateById(uptenantSalesOrderStoreDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tenantsalesorderstoredetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tenantSalesOrderStoreDetailServiceImpl.removeById(id));
  }

  @PostMapping("/tenantsalesorderstoredetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tenant_sales_order_store_detail");
     params.put("request", condition);

     return XfR.ok(tenantSalesOrderStoreDetailServiceImpl.querys(params));
  }

}
