package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.ImportFileCheckConfig;
import com.xforceplus.arterydocument.service.IImportFileCheckConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-03
 */
@RestController
public class ImportFileCheckConfigController {

  @Autowired
  private IImportFileCheckConfigService importFileCheckConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param importFileCheckConfig ${table.comment}
   * @return
   */
  @GetMapping("/importfilecheckconfigs" )
  public XfR getImportFileCheckConfigs(XfPage page, ImportFileCheckConfig importFileCheckConfig) {
    return XfR.ok(importFileCheckConfigServiceImpl.page(page, Wrappers.query(importFileCheckConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/importfilecheckconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(importFileCheckConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param importFileCheckConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/importfilecheckconfigs")
  public XfR save(@RequestBody ImportFileCheckConfig importFileCheckConfig) {
     return XfR.ok(importFileCheckConfigServiceImpl.save(importFileCheckConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param importFileCheckConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/importfilecheckconfigs/{id}")
  public XfR putUpdate(@RequestBody ImportFileCheckConfig importFileCheckConfig,@PathVariable Long id) {
      importFileCheckConfig.setId(id);
      return XfR.ok(importFileCheckConfigServiceImpl.updateById(importFileCheckConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param importFileCheckConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/importfilecheckconfigs/{id}")
  public XfR patchUpdate(@RequestBody ImportFileCheckConfig importFileCheckConfig,@PathVariable Long id) {
      ImportFileCheckConfig upimportFileCheckConfig = importFileCheckConfigServiceImpl.getById(id);
      if(upimportFileCheckConfig != null){
        upimportFileCheckConfig = ObjectCopyUtils.copyProperties(importFileCheckConfig,upimportFileCheckConfig,true);
      }
      return XfR.ok(importFileCheckConfigServiceImpl.updateById(upimportFileCheckConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/importfilecheckconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(importFileCheckConfigServiceImpl.removeById(id));
  }

  @PostMapping("/importfilecheckconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "import_file_check_config");
     params.put("request", condition);

     return XfR.ok(importFileCheckConfigServiceImpl.querys(params));
  }

}
