package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.PosBackTracking;
import com.xforceplus.arterydocument.service.IPosBackTrackingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 弃用前端控制器
 *
 * @author ultraman
 * @date 2024-12-03
 */
@RestController
public class PosBackTrackingController {

  @Autowired
  private IPosBackTrackingService posBackTrackingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param posBackTracking 弃用
   * @return
   */
  @GetMapping("/posbacktrackings" )
  public XfR getPosBackTrackings(XfPage page, PosBackTracking posBackTracking) {
    return XfR.ok(posBackTrackingServiceImpl.page(page, Wrappers.query(posBackTracking)));
  }

  /**
   * 通过id查询弃用
   * @param  id
   * @return XfR
   */
  @GetMapping("/posbacktrackings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(posBackTrackingServiceImpl.getById(id));
  }

  /**
   * 新增弃用
   * @param posBackTracking 弃用
   * @return XfR
   */
  @PostMapping("/posbacktrackings")
  public XfR save(@RequestBody PosBackTracking posBackTracking) {
     return XfR.ok(posBackTrackingServiceImpl.save(posBackTracking));
  }

  /**
   * 修改-传入修改后的全部数据弃用
   * @param posBackTracking 弃用
   * @return XfR
   */
  @PutMapping("/posbacktrackings/{id}")
  public XfR putUpdate(@RequestBody PosBackTracking posBackTracking,@PathVariable Long id) {
      posBackTracking.setId(id);
      return XfR.ok(posBackTrackingServiceImpl.updateById(posBackTracking));
  }

  /**
   * 修改-传入修改的数据弃用
   * @param posBackTracking 弃用
   * @return XfR
   */
  @PatchMapping("/posbacktrackings/{id}")
  public XfR patchUpdate(@RequestBody PosBackTracking posBackTracking,@PathVariable Long id) {
      PosBackTracking upposBackTracking = posBackTrackingServiceImpl.getById(id);
      if(upposBackTracking != null){
        upposBackTracking = ObjectCopyUtils.copyProperties(posBackTracking,upposBackTracking,true);
      }
      return XfR.ok(posBackTrackingServiceImpl.updateById(upposBackTracking));
  }

  /**
   * 通过id删除弃用
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/posbacktrackings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(posBackTrackingServiceImpl.removeById(id));
  }

  @PostMapping("/posbacktrackings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pos_back_tracking");
     params.put("request", condition);

     return XfR.ok(posBackTrackingServiceImpl.querys(params));
  }

}
