package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.ReservationDeliveryNoteDetail;
import com.xforceplus.arterydocument.service.IReservationDeliveryNoteDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 送货预约明细前端控制器
 *
 * @author ultraman
 * @date 2024-12-03
 */
@RestController
public class ReservationDeliveryNoteDetailController {

  @Autowired
  private IReservationDeliveryNoteDetailService reservationDeliveryNoteDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reservationDeliveryNoteDetail 送货预约明细
   * @return
   */
  @GetMapping("/reservationdeliverynotedetails" )
  public XfR getReservationDeliveryNoteDetails(XfPage page, ReservationDeliveryNoteDetail reservationDeliveryNoteDetail) {
    return XfR.ok(reservationDeliveryNoteDetailServiceImpl.page(page, Wrappers.query(reservationDeliveryNoteDetail)));
  }

  /**
   * 通过id查询送货预约明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/reservationdeliverynotedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reservationDeliveryNoteDetailServiceImpl.getById(id));
  }

  /**
   * 新增送货预约明细
   * @param reservationDeliveryNoteDetail 送货预约明细
   * @return XfR
   */
  @PostMapping("/reservationdeliverynotedetails")
  public XfR save(@RequestBody ReservationDeliveryNoteDetail reservationDeliveryNoteDetail) {
     return XfR.ok(reservationDeliveryNoteDetailServiceImpl.save(reservationDeliveryNoteDetail));
  }

  /**
   * 修改-传入修改后的全部数据送货预约明细
   * @param reservationDeliveryNoteDetail 送货预约明细
   * @return XfR
   */
  @PutMapping("/reservationdeliverynotedetails/{id}")
  public XfR putUpdate(@RequestBody ReservationDeliveryNoteDetail reservationDeliveryNoteDetail,@PathVariable Long id) {
      reservationDeliveryNoteDetail.setId(id);
      return XfR.ok(reservationDeliveryNoteDetailServiceImpl.updateById(reservationDeliveryNoteDetail));
  }

  /**
   * 修改-传入修改的数据送货预约明细
   * @param reservationDeliveryNoteDetail 送货预约明细
   * @return XfR
   */
  @PatchMapping("/reservationdeliverynotedetails/{id}")
  public XfR patchUpdate(@RequestBody ReservationDeliveryNoteDetail reservationDeliveryNoteDetail,@PathVariable Long id) {
      ReservationDeliveryNoteDetail upreservationDeliveryNoteDetail = reservationDeliveryNoteDetailServiceImpl.getById(id);
      if(upreservationDeliveryNoteDetail != null){
        upreservationDeliveryNoteDetail = ObjectCopyUtils.copyProperties(reservationDeliveryNoteDetail,upreservationDeliveryNoteDetail,true);
      }
      return XfR.ok(reservationDeliveryNoteDetailServiceImpl.updateById(upreservationDeliveryNoteDetail));
  }

  /**
   * 通过id删除送货预约明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reservationdeliverynotedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reservationDeliveryNoteDetailServiceImpl.removeById(id));
  }

  @PostMapping("/reservationdeliverynotedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "reservation_delivery_note_detail");
     params.put("request", condition);

     return XfR.ok(reservationDeliveryNoteDetailServiceImpl.querys(params));
  }

}
