package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.SettlementDocAdvInvoiceDetail;
import com.xforceplus.arterydocument.service.ISettlementDocAdvInvoiceDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * V2前端控制器
 *
 * @author ultraman
 * @date 2024-12-03
 */
@RestController
public class SettlementDocAdvInvoiceDetailController {

  @Autowired
  private ISettlementDocAdvInvoiceDetailService settlementDocAdvInvoiceDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementDocAdvInvoiceDetail V2
   * @return
   */
  @GetMapping("/settlementdocadvinvoicedetails" )
  public XfR getSettlementDocAdvInvoiceDetails(XfPage page, SettlementDocAdvInvoiceDetail settlementDocAdvInvoiceDetail) {
    return XfR.ok(settlementDocAdvInvoiceDetailServiceImpl.page(page, Wrappers.query(settlementDocAdvInvoiceDetail)));
  }

  /**
   * 通过id查询V2
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementdocadvinvoicedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementDocAdvInvoiceDetailServiceImpl.getById(id));
  }

  /**
   * 新增V2
   * @param settlementDocAdvInvoiceDetail V2
   * @return XfR
   */
  @PostMapping("/settlementdocadvinvoicedetails")
  public XfR save(@RequestBody SettlementDocAdvInvoiceDetail settlementDocAdvInvoiceDetail) {
     return XfR.ok(settlementDocAdvInvoiceDetailServiceImpl.save(settlementDocAdvInvoiceDetail));
  }

  /**
   * 修改-传入修改后的全部数据V2
   * @param settlementDocAdvInvoiceDetail V2
   * @return XfR
   */
  @PutMapping("/settlementdocadvinvoicedetails/{id}")
  public XfR putUpdate(@RequestBody SettlementDocAdvInvoiceDetail settlementDocAdvInvoiceDetail,@PathVariable Long id) {
      settlementDocAdvInvoiceDetail.setId(id);
      return XfR.ok(settlementDocAdvInvoiceDetailServiceImpl.updateById(settlementDocAdvInvoiceDetail));
  }

  /**
   * 修改-传入修改的数据V2
   * @param settlementDocAdvInvoiceDetail V2
   * @return XfR
   */
  @PatchMapping("/settlementdocadvinvoicedetails/{id}")
  public XfR patchUpdate(@RequestBody SettlementDocAdvInvoiceDetail settlementDocAdvInvoiceDetail,@PathVariable Long id) {
      SettlementDocAdvInvoiceDetail upsettlementDocAdvInvoiceDetail = settlementDocAdvInvoiceDetailServiceImpl.getById(id);
      if(upsettlementDocAdvInvoiceDetail != null){
        upsettlementDocAdvInvoiceDetail = ObjectCopyUtils.copyProperties(settlementDocAdvInvoiceDetail,upsettlementDocAdvInvoiceDetail,true);
      }
      return XfR.ok(settlementDocAdvInvoiceDetailServiceImpl.updateById(upsettlementDocAdvInvoiceDetail));
  }

  /**
   * 通过id删除V2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementdocadvinvoicedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementDocAdvInvoiceDetailServiceImpl.removeById(id));
  }

  @PostMapping("/settlementdocadvinvoicedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_doc_adv_invoice_detail");
     params.put("request", condition);

     return XfR.ok(settlementDocAdvInvoiceDetailServiceImpl.querys(params));
  }

}
