package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.SettlementPurchaserInvoiceDetail;
import com.xforceplus.arterydocument.service.ISettlementPurchaserInvoiceDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-03
 */
@RestController
public class SettlementPurchaserInvoiceDetailController {

  @Autowired
  private ISettlementPurchaserInvoiceDetailService settlementPurchaserInvoiceDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementPurchaserInvoiceDetail ${table.comment}
   * @return
   */
  @GetMapping("/settlementpurchaserinvoicedetails" )
  public XfR getSettlementPurchaserInvoiceDetails(XfPage page, SettlementPurchaserInvoiceDetail settlementPurchaserInvoiceDetail) {
    return XfR.ok(settlementPurchaserInvoiceDetailServiceImpl.page(page, Wrappers.query(settlementPurchaserInvoiceDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementpurchaserinvoicedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementPurchaserInvoiceDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param settlementPurchaserInvoiceDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/settlementpurchaserinvoicedetails")
  public XfR save(@RequestBody SettlementPurchaserInvoiceDetail settlementPurchaserInvoiceDetail) {
     return XfR.ok(settlementPurchaserInvoiceDetailServiceImpl.save(settlementPurchaserInvoiceDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param settlementPurchaserInvoiceDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/settlementpurchaserinvoicedetails/{id}")
  public XfR putUpdate(@RequestBody SettlementPurchaserInvoiceDetail settlementPurchaserInvoiceDetail,@PathVariable Long id) {
      settlementPurchaserInvoiceDetail.setId(id);
      return XfR.ok(settlementPurchaserInvoiceDetailServiceImpl.updateById(settlementPurchaserInvoiceDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param settlementPurchaserInvoiceDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/settlementpurchaserinvoicedetails/{id}")
  public XfR patchUpdate(@RequestBody SettlementPurchaserInvoiceDetail settlementPurchaserInvoiceDetail,@PathVariable Long id) {
      SettlementPurchaserInvoiceDetail upsettlementPurchaserInvoiceDetail = settlementPurchaserInvoiceDetailServiceImpl.getById(id);
      if(upsettlementPurchaserInvoiceDetail != null){
        upsettlementPurchaserInvoiceDetail = ObjectCopyUtils.copyProperties(settlementPurchaserInvoiceDetail,upsettlementPurchaserInvoiceDetail,true);
      }
      return XfR.ok(settlementPurchaserInvoiceDetailServiceImpl.updateById(upsettlementPurchaserInvoiceDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementpurchaserinvoicedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementPurchaserInvoiceDetailServiceImpl.removeById(id));
  }

  @PostMapping("/settlementpurchaserinvoicedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_purchaser_invoice_detail");
     params.put("request", condition);

     return XfR.ok(settlementPurchaserInvoiceDetailServiceImpl.querys(params));
  }

}
