package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.SupermarketWritebackOptions;
import com.xforceplus.arterydocument.service.ISupermarketWritebackOptionsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 商超回写选项前端控制器
 *
 * @author ultraman
 * @date 2024-12-03
 */
@RestController
public class SupermarketWritebackOptionsController {

  @Autowired
  private ISupermarketWritebackOptionsService supermarketWritebackOptionsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param supermarketWritebackOptions 商超回写选项
   * @return
   */
  @GetMapping("/supermarketwritebackoptionss" )
  public XfR getSupermarketWritebackOptionss(XfPage page, SupermarketWritebackOptions supermarketWritebackOptions) {
    return XfR.ok(supermarketWritebackOptionsServiceImpl.page(page, Wrappers.query(supermarketWritebackOptions)));
  }

  /**
   * 通过id查询商超回写选项
   * @param  id
   * @return XfR
   */
  @GetMapping("/supermarketwritebackoptionss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(supermarketWritebackOptionsServiceImpl.getById(id));
  }

  /**
   * 新增商超回写选项
   * @param supermarketWritebackOptions 商超回写选项
   * @return XfR
   */
  @PostMapping("/supermarketwritebackoptionss")
  public XfR save(@RequestBody SupermarketWritebackOptions supermarketWritebackOptions) {
     return XfR.ok(supermarketWritebackOptionsServiceImpl.save(supermarketWritebackOptions));
  }

  /**
   * 修改-传入修改后的全部数据商超回写选项
   * @param supermarketWritebackOptions 商超回写选项
   * @return XfR
   */
  @PutMapping("/supermarketwritebackoptionss/{id}")
  public XfR putUpdate(@RequestBody SupermarketWritebackOptions supermarketWritebackOptions,@PathVariable Long id) {
      supermarketWritebackOptions.setId(id);
      return XfR.ok(supermarketWritebackOptionsServiceImpl.updateById(supermarketWritebackOptions));
  }

  /**
   * 修改-传入修改的数据商超回写选项
   * @param supermarketWritebackOptions 商超回写选项
   * @return XfR
   */
  @PatchMapping("/supermarketwritebackoptionss/{id}")
  public XfR patchUpdate(@RequestBody SupermarketWritebackOptions supermarketWritebackOptions,@PathVariable Long id) {
      SupermarketWritebackOptions upsupermarketWritebackOptions = supermarketWritebackOptionsServiceImpl.getById(id);
      if(upsupermarketWritebackOptions != null){
        upsupermarketWritebackOptions = ObjectCopyUtils.copyProperties(supermarketWritebackOptions,upsupermarketWritebackOptions,true);
      }
      return XfR.ok(supermarketWritebackOptionsServiceImpl.updateById(upsupermarketWritebackOptions));
  }

  /**
   * 通过id删除商超回写选项
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/supermarketwritebackoptionss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(supermarketWritebackOptionsServiceImpl.removeById(id));
  }

  @PostMapping("/supermarketwritebackoptionss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "supermarket_writeback_options");
     params.put("request", condition);

     return XfR.ok(supermarketWritebackOptionsServiceImpl.querys(params));
  }

}
