package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.BusinessFlowRuleDetail;
import com.xforceplus.arterydocument.service.IBusinessFlowRuleDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-10
 */
@RestController
public class BusinessFlowRuleDetailController {

  @Autowired
  private IBusinessFlowRuleDetailService businessFlowRuleDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param businessFlowRuleDetail ${table.comment}
   * @return
   */
  @GetMapping("/businessflowruledetails" )
  public XfR getBusinessFlowRuleDetails(XfPage page, BusinessFlowRuleDetail businessFlowRuleDetail) {
    return XfR.ok(businessFlowRuleDetailServiceImpl.page(page, Wrappers.query(businessFlowRuleDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/businessflowruledetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(businessFlowRuleDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param businessFlowRuleDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/businessflowruledetails")
  public XfR save(@RequestBody BusinessFlowRuleDetail businessFlowRuleDetail) {
     return XfR.ok(businessFlowRuleDetailServiceImpl.save(businessFlowRuleDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param businessFlowRuleDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/businessflowruledetails/{id}")
  public XfR putUpdate(@RequestBody BusinessFlowRuleDetail businessFlowRuleDetail,@PathVariable Long id) {
      businessFlowRuleDetail.setId(id);
      return XfR.ok(businessFlowRuleDetailServiceImpl.updateById(businessFlowRuleDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param businessFlowRuleDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/businessflowruledetails/{id}")
  public XfR patchUpdate(@RequestBody BusinessFlowRuleDetail businessFlowRuleDetail,@PathVariable Long id) {
      BusinessFlowRuleDetail upbusinessFlowRuleDetail = businessFlowRuleDetailServiceImpl.getById(id);
      if(upbusinessFlowRuleDetail != null){
        upbusinessFlowRuleDetail = ObjectCopyUtils.copyProperties(businessFlowRuleDetail,upbusinessFlowRuleDetail,true);
      }
      return XfR.ok(businessFlowRuleDetailServiceImpl.updateById(upbusinessFlowRuleDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/businessflowruledetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(businessFlowRuleDetailServiceImpl.removeById(id));
  }

  @PostMapping("/businessflowruledetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "business_flow_rule_detail");
     params.put("request", condition);

     return XfR.ok(businessFlowRuleDetailServiceImpl.querys(params));
  }

}
