package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.BusinessTag;
import com.xforceplus.arterydocument.service.IBusinessTagService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-10
 */
@RestController
public class BusinessTagController {

  @Autowired
  private IBusinessTagService businessTagServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param businessTag ${table.comment}
   * @return
   */
  @GetMapping("/businesstags" )
  public XfR getBusinessTags(XfPage page, BusinessTag businessTag) {
    return XfR.ok(businessTagServiceImpl.page(page, Wrappers.query(businessTag)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/businesstags/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(businessTagServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param businessTag ${table.comment}
   * @return XfR
   */
  @PostMapping("/businesstags")
  public XfR save(@RequestBody BusinessTag businessTag) {
     return XfR.ok(businessTagServiceImpl.save(businessTag));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param businessTag ${table.comment}
   * @return XfR
   */
  @PutMapping("/businesstags/{id}")
  public XfR putUpdate(@RequestBody BusinessTag businessTag,@PathVariable Long id) {
      businessTag.setId(id);
      return XfR.ok(businessTagServiceImpl.updateById(businessTag));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param businessTag ${table.comment}
   * @return XfR
   */
  @PatchMapping("/businesstags/{id}")
  public XfR patchUpdate(@RequestBody BusinessTag businessTag,@PathVariable Long id) {
      BusinessTag upbusinessTag = businessTagServiceImpl.getById(id);
      if(upbusinessTag != null){
        upbusinessTag = ObjectCopyUtils.copyProperties(businessTag,upbusinessTag,true);
      }
      return XfR.ok(businessTagServiceImpl.updateById(upbusinessTag));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/businesstags/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(businessTagServiceImpl.removeById(id));
  }

  @PostMapping("/businesstags/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "business_tag");
     params.put("request", condition);

     return XfR.ok(businessTagServiceImpl.querys(params));
  }

}
