package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.ExecutionTaskResponse;
import com.xforceplus.arterydocument.service.IExecutionTaskResponseService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-10
 */
@RestController
public class ExecutionTaskResponseController {

  @Autowired
  private IExecutionTaskResponseService executionTaskResponseServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param executionTaskResponse ${table.comment}
   * @return
   */
  @GetMapping("/executiontaskresponses" )
  public XfR getExecutionTaskResponses(XfPage page, ExecutionTaskResponse executionTaskResponse) {
    return XfR.ok(executionTaskResponseServiceImpl.page(page, Wrappers.query(executionTaskResponse)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/executiontaskresponses/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(executionTaskResponseServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param executionTaskResponse ${table.comment}
   * @return XfR
   */
  @PostMapping("/executiontaskresponses")
  public XfR save(@RequestBody ExecutionTaskResponse executionTaskResponse) {
     return XfR.ok(executionTaskResponseServiceImpl.save(executionTaskResponse));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param executionTaskResponse ${table.comment}
   * @return XfR
   */
  @PutMapping("/executiontaskresponses/{id}")
  public XfR putUpdate(@RequestBody ExecutionTaskResponse executionTaskResponse,@PathVariable Long id) {
      executionTaskResponse.setId(id);
      return XfR.ok(executionTaskResponseServiceImpl.updateById(executionTaskResponse));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param executionTaskResponse ${table.comment}
   * @return XfR
   */
  @PatchMapping("/executiontaskresponses/{id}")
  public XfR patchUpdate(@RequestBody ExecutionTaskResponse executionTaskResponse,@PathVariable Long id) {
      ExecutionTaskResponse upexecutionTaskResponse = executionTaskResponseServiceImpl.getById(id);
      if(upexecutionTaskResponse != null){
        upexecutionTaskResponse = ObjectCopyUtils.copyProperties(executionTaskResponse,upexecutionTaskResponse,true);
      }
      return XfR.ok(executionTaskResponseServiceImpl.updateById(upexecutionTaskResponse));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/executiontaskresponses/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(executionTaskResponseServiceImpl.removeById(id));
  }

  @PostMapping("/executiontaskresponses/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "execution_task_response");
     params.put("request", condition);

     return XfR.ok(executionTaskResponseServiceImpl.querys(params));
  }

}
