package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.FinanceGoodsReceiveNote;
import com.xforceplus.arterydocument.service.IFinanceGoodsReceiveNoteService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-10
 */
@RestController
public class FinanceGoodsReceiveNoteController {

  @Autowired
  private IFinanceGoodsReceiveNoteService financeGoodsReceiveNoteServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financeGoodsReceiveNote ${table.comment}
   * @return
   */
  @GetMapping("/financegoodsreceivenotes" )
  public XfR getFinanceGoodsReceiveNotes(XfPage page, FinanceGoodsReceiveNote financeGoodsReceiveNote) {
    return XfR.ok(financeGoodsReceiveNoteServiceImpl.page(page, Wrappers.query(financeGoodsReceiveNote)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financegoodsreceivenotes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financeGoodsReceiveNoteServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financeGoodsReceiveNote ${table.comment}
   * @return XfR
   */
  @PostMapping("/financegoodsreceivenotes")
  public XfR save(@RequestBody FinanceGoodsReceiveNote financeGoodsReceiveNote) {
     return XfR.ok(financeGoodsReceiveNoteServiceImpl.save(financeGoodsReceiveNote));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financeGoodsReceiveNote ${table.comment}
   * @return XfR
   */
  @PutMapping("/financegoodsreceivenotes/{id}")
  public XfR putUpdate(@RequestBody FinanceGoodsReceiveNote financeGoodsReceiveNote,@PathVariable Long id) {
      financeGoodsReceiveNote.setId(id);
      return XfR.ok(financeGoodsReceiveNoteServiceImpl.updateById(financeGoodsReceiveNote));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financeGoodsReceiveNote ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financegoodsreceivenotes/{id}")
  public XfR patchUpdate(@RequestBody FinanceGoodsReceiveNote financeGoodsReceiveNote,@PathVariable Long id) {
      FinanceGoodsReceiveNote upfinanceGoodsReceiveNote = financeGoodsReceiveNoteServiceImpl.getById(id);
      if(upfinanceGoodsReceiveNote != null){
        upfinanceGoodsReceiveNote = ObjectCopyUtils.copyProperties(financeGoodsReceiveNote,upfinanceGoodsReceiveNote,true);
      }
      return XfR.ok(financeGoodsReceiveNoteServiceImpl.updateById(upfinanceGoodsReceiveNote));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financegoodsreceivenotes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financeGoodsReceiveNoteServiceImpl.removeById(id));
  }

  @PostMapping("/financegoodsreceivenotes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "finance_goods_receive_note");
     params.put("request", condition);

     return XfR.ok(financeGoodsReceiveNoteServiceImpl.querys(params));
  }

}
