package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.FinanceGoodsReceiveNoteDetail;
import com.xforceplus.arterydocument.service.IFinanceGoodsReceiveNoteDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-10
 */
@RestController
public class FinanceGoodsReceiveNoteDetailController {

  @Autowired
  private IFinanceGoodsReceiveNoteDetailService financeGoodsReceiveNoteDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financeGoodsReceiveNoteDetail ${table.comment}
   * @return
   */
  @GetMapping("/financegoodsreceivenotedetails" )
  public XfR getFinanceGoodsReceiveNoteDetails(XfPage page, FinanceGoodsReceiveNoteDetail financeGoodsReceiveNoteDetail) {
    return XfR.ok(financeGoodsReceiveNoteDetailServiceImpl.page(page, Wrappers.query(financeGoodsReceiveNoteDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financegoodsreceivenotedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financeGoodsReceiveNoteDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financeGoodsReceiveNoteDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/financegoodsreceivenotedetails")
  public XfR save(@RequestBody FinanceGoodsReceiveNoteDetail financeGoodsReceiveNoteDetail) {
     return XfR.ok(financeGoodsReceiveNoteDetailServiceImpl.save(financeGoodsReceiveNoteDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financeGoodsReceiveNoteDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/financegoodsreceivenotedetails/{id}")
  public XfR putUpdate(@RequestBody FinanceGoodsReceiveNoteDetail financeGoodsReceiveNoteDetail,@PathVariable Long id) {
      financeGoodsReceiveNoteDetail.setId(id);
      return XfR.ok(financeGoodsReceiveNoteDetailServiceImpl.updateById(financeGoodsReceiveNoteDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financeGoodsReceiveNoteDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financegoodsreceivenotedetails/{id}")
  public XfR patchUpdate(@RequestBody FinanceGoodsReceiveNoteDetail financeGoodsReceiveNoteDetail,@PathVariable Long id) {
      FinanceGoodsReceiveNoteDetail upfinanceGoodsReceiveNoteDetail = financeGoodsReceiveNoteDetailServiceImpl.getById(id);
      if(upfinanceGoodsReceiveNoteDetail != null){
        upfinanceGoodsReceiveNoteDetail = ObjectCopyUtils.copyProperties(financeGoodsReceiveNoteDetail,upfinanceGoodsReceiveNoteDetail,true);
      }
      return XfR.ok(financeGoodsReceiveNoteDetailServiceImpl.updateById(upfinanceGoodsReceiveNoteDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financegoodsreceivenotedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financeGoodsReceiveNoteDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financegoodsreceivenotedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "finance_goods_receive_note_detail");
     params.put("request", condition);

     return XfR.ok(financeGoodsReceiveNoteDetailServiceImpl.querys(params));
  }

}
