package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.FinanceReturnToVendor;
import com.xforceplus.arterydocument.service.IFinanceReturnToVendorService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-10
 */
@RestController
public class FinanceReturnToVendorController {

  @Autowired
  private IFinanceReturnToVendorService financeReturnToVendorServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financeReturnToVendor ${table.comment}
   * @return
   */
  @GetMapping("/financereturntovendors" )
  public XfR getFinanceReturnToVendors(XfPage page, FinanceReturnToVendor financeReturnToVendor) {
    return XfR.ok(financeReturnToVendorServiceImpl.page(page, Wrappers.query(financeReturnToVendor)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financereturntovendors/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financeReturnToVendorServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financeReturnToVendor ${table.comment}
   * @return XfR
   */
  @PostMapping("/financereturntovendors")
  public XfR save(@RequestBody FinanceReturnToVendor financeReturnToVendor) {
     return XfR.ok(financeReturnToVendorServiceImpl.save(financeReturnToVendor));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financeReturnToVendor ${table.comment}
   * @return XfR
   */
  @PutMapping("/financereturntovendors/{id}")
  public XfR putUpdate(@RequestBody FinanceReturnToVendor financeReturnToVendor,@PathVariable Long id) {
      financeReturnToVendor.setId(id);
      return XfR.ok(financeReturnToVendorServiceImpl.updateById(financeReturnToVendor));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financeReturnToVendor ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financereturntovendors/{id}")
  public XfR patchUpdate(@RequestBody FinanceReturnToVendor financeReturnToVendor,@PathVariable Long id) {
      FinanceReturnToVendor upfinanceReturnToVendor = financeReturnToVendorServiceImpl.getById(id);
      if(upfinanceReturnToVendor != null){
        upfinanceReturnToVendor = ObjectCopyUtils.copyProperties(financeReturnToVendor,upfinanceReturnToVendor,true);
      }
      return XfR.ok(financeReturnToVendorServiceImpl.updateById(upfinanceReturnToVendor));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financereturntovendors/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financeReturnToVendorServiceImpl.removeById(id));
  }

  @PostMapping("/financereturntovendors/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "finance_return_to_vendor");
     params.put("request", condition);

     return XfR.ok(financeReturnToVendorServiceImpl.querys(params));
  }

}
