package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.HuaweicloudOrder;
import com.xforceplus.arterydocument.service.IHuaweicloudOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-10
 */
@RestController
public class HuaweicloudOrderController {

  @Autowired
  private IHuaweicloudOrderService huaweicloudOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param huaweicloudOrder ${table.comment}
   * @return
   */
  @GetMapping("/huaweicloudorders" )
  public XfR getHuaweicloudOrders(XfPage page, HuaweicloudOrder huaweicloudOrder) {
    return XfR.ok(huaweicloudOrderServiceImpl.page(page, Wrappers.query(huaweicloudOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/huaweicloudorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(huaweicloudOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param huaweicloudOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/huaweicloudorders")
  public XfR save(@RequestBody HuaweicloudOrder huaweicloudOrder) {
     return XfR.ok(huaweicloudOrderServiceImpl.save(huaweicloudOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param huaweicloudOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/huaweicloudorders/{id}")
  public XfR putUpdate(@RequestBody HuaweicloudOrder huaweicloudOrder,@PathVariable Long id) {
      huaweicloudOrder.setId(id);
      return XfR.ok(huaweicloudOrderServiceImpl.updateById(huaweicloudOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param huaweicloudOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/huaweicloudorders/{id}")
  public XfR patchUpdate(@RequestBody HuaweicloudOrder huaweicloudOrder,@PathVariable Long id) {
      HuaweicloudOrder uphuaweicloudOrder = huaweicloudOrderServiceImpl.getById(id);
      if(uphuaweicloudOrder != null){
        uphuaweicloudOrder = ObjectCopyUtils.copyProperties(huaweicloudOrder,uphuaweicloudOrder,true);
      }
      return XfR.ok(huaweicloudOrderServiceImpl.updateById(uphuaweicloudOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/huaweicloudorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(huaweicloudOrderServiceImpl.removeById(id));
  }

  @PostMapping("/huaweicloudorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "huaweicloud_order");
     params.put("request", condition);

     return XfR.ok(huaweicloudOrderServiceImpl.querys(params));
  }

}
