package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.RetryConfig;
import com.xforceplus.arterydocument.service.IRetryConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-10
 */
@RestController
public class RetryConfigController {

  @Autowired
  private IRetryConfigService retryConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param retryConfig ${table.comment}
   * @return
   */
  @GetMapping("/retryconfigs" )
  public XfR getRetryConfigs(XfPage page, RetryConfig retryConfig) {
    return XfR.ok(retryConfigServiceImpl.page(page, Wrappers.query(retryConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/retryconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(retryConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param retryConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/retryconfigs")
  public XfR save(@RequestBody RetryConfig retryConfig) {
     return XfR.ok(retryConfigServiceImpl.save(retryConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param retryConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/retryconfigs/{id}")
  public XfR putUpdate(@RequestBody RetryConfig retryConfig,@PathVariable Long id) {
      retryConfig.setId(id);
      return XfR.ok(retryConfigServiceImpl.updateById(retryConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param retryConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/retryconfigs/{id}")
  public XfR patchUpdate(@RequestBody RetryConfig retryConfig,@PathVariable Long id) {
      RetryConfig upretryConfig = retryConfigServiceImpl.getById(id);
      if(upretryConfig != null){
        upretryConfig = ObjectCopyUtils.copyProperties(retryConfig,upretryConfig,true);
      }
      return XfR.ok(retryConfigServiceImpl.updateById(upretryConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/retryconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(retryConfigServiceImpl.removeById(id));
  }

  @PostMapping("/retryconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "retry_config");
     params.put("request", condition);

     return XfR.ok(retryConfigServiceImpl.querys(params));
  }

}
