package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.ServiceApplication;
import com.xforceplus.arterydocument.service.IServiceApplicationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-10
 */
@RestController
public class ServiceApplicationController {

  @Autowired
  private IServiceApplicationService serviceApplicationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param serviceApplication ${table.comment}
   * @return
   */
  @GetMapping("/serviceapplications" )
  public XfR getServiceApplications(XfPage page, ServiceApplication serviceApplication) {
    return XfR.ok(serviceApplicationServiceImpl.page(page, Wrappers.query(serviceApplication)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/serviceapplications/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(serviceApplicationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param serviceApplication ${table.comment}
   * @return XfR
   */
  @PostMapping("/serviceapplications")
  public XfR save(@RequestBody ServiceApplication serviceApplication) {
     return XfR.ok(serviceApplicationServiceImpl.save(serviceApplication));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param serviceApplication ${table.comment}
   * @return XfR
   */
  @PutMapping("/serviceapplications/{id}")
  public XfR putUpdate(@RequestBody ServiceApplication serviceApplication,@PathVariable Long id) {
      serviceApplication.setId(id);
      return XfR.ok(serviceApplicationServiceImpl.updateById(serviceApplication));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param serviceApplication ${table.comment}
   * @return XfR
   */
  @PatchMapping("/serviceapplications/{id}")
  public XfR patchUpdate(@RequestBody ServiceApplication serviceApplication,@PathVariable Long id) {
      ServiceApplication upserviceApplication = serviceApplicationServiceImpl.getById(id);
      if(upserviceApplication != null){
        upserviceApplication = ObjectCopyUtils.copyProperties(serviceApplication,upserviceApplication,true);
      }
      return XfR.ok(serviceApplicationServiceImpl.updateById(upserviceApplication));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/serviceapplications/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(serviceApplicationServiceImpl.removeById(id));
  }

  @PostMapping("/serviceapplications/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "service_application");
     params.put("request", condition);

     return XfR.ok(serviceApplicationServiceImpl.querys(params));
  }

}
