package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.SupermarketStoreInfo;
import com.xforceplus.arterydocument.service.ISupermarketStoreInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-10
 */
@RestController
public class SupermarketStoreInfoController {

  @Autowired
  private ISupermarketStoreInfoService supermarketStoreInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param supermarketStoreInfo ${table.comment}
   * @return
   */
  @GetMapping("/supermarketstoreinfos" )
  public XfR getSupermarketStoreInfos(XfPage page, SupermarketStoreInfo supermarketStoreInfo) {
    return XfR.ok(supermarketStoreInfoServiceImpl.page(page, Wrappers.query(supermarketStoreInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/supermarketstoreinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(supermarketStoreInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param supermarketStoreInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/supermarketstoreinfos")
  public XfR save(@RequestBody SupermarketStoreInfo supermarketStoreInfo) {
     return XfR.ok(supermarketStoreInfoServiceImpl.save(supermarketStoreInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param supermarketStoreInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/supermarketstoreinfos/{id}")
  public XfR putUpdate(@RequestBody SupermarketStoreInfo supermarketStoreInfo,@PathVariable Long id) {
      supermarketStoreInfo.setId(id);
      return XfR.ok(supermarketStoreInfoServiceImpl.updateById(supermarketStoreInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param supermarketStoreInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/supermarketstoreinfos/{id}")
  public XfR patchUpdate(@RequestBody SupermarketStoreInfo supermarketStoreInfo,@PathVariable Long id) {
      SupermarketStoreInfo upsupermarketStoreInfo = supermarketStoreInfoServiceImpl.getById(id);
      if(upsupermarketStoreInfo != null){
        upsupermarketStoreInfo = ObjectCopyUtils.copyProperties(supermarketStoreInfo,upsupermarketStoreInfo,true);
      }
      return XfR.ok(supermarketStoreInfoServiceImpl.updateById(upsupermarketStoreInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/supermarketstoreinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(supermarketStoreInfoServiceImpl.removeById(id));
  }

  @PostMapping("/supermarketstoreinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "supermarket_store_info");
     params.put("request", condition);

     return XfR.ok(supermarketStoreInfoServiceImpl.querys(params));
  }

}
