package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.SysConfig;
import com.xforceplus.arterydocument.service.ISysConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-10
 */
@RestController
public class SysConfigController {

  @Autowired
  private ISysConfigService sysConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sysConfig ${table.comment}
   * @return
   */
  @GetMapping("/sysconfigs" )
  public XfR getSysConfigs(XfPage page, SysConfig sysConfig) {
    return XfR.ok(sysConfigServiceImpl.page(page, Wrappers.query(sysConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/sysconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sysConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sysConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/sysconfigs")
  public XfR save(@RequestBody SysConfig sysConfig) {
     return XfR.ok(sysConfigServiceImpl.save(sysConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sysConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/sysconfigs/{id}")
  public XfR putUpdate(@RequestBody SysConfig sysConfig,@PathVariable Long id) {
      sysConfig.setId(id);
      return XfR.ok(sysConfigServiceImpl.updateById(sysConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sysConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/sysconfigs/{id}")
  public XfR patchUpdate(@RequestBody SysConfig sysConfig,@PathVariable Long id) {
      SysConfig upsysConfig = sysConfigServiceImpl.getById(id);
      if(upsysConfig != null){
        upsysConfig = ObjectCopyUtils.copyProperties(sysConfig,upsysConfig,true);
      }
      return XfR.ok(sysConfigServiceImpl.updateById(upsysConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sysconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sysConfigServiceImpl.removeById(id));
  }

  @PostMapping("/sysconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sys_config");
     params.put("request", condition);

     return XfR.ok(sysConfigServiceImpl.querys(params));
  }

}
