package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.WalmartInvoiceRelationPO;
import com.xforceplus.arterydocument.service.IWalmartInvoiceRelationPOService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-10
 */
@RestController
public class WalmartInvoiceRelationPOController {

  @Autowired
  private IWalmartInvoiceRelationPOService walmartInvoiceRelationPOServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param walmartInvoiceRelationPO ${table.comment}
   * @return
   */
  @GetMapping("/walmartinvoicerelationpos" )
  public XfR getWalmartInvoiceRelationPOs(XfPage page, WalmartInvoiceRelationPO walmartInvoiceRelationPO) {
    return XfR.ok(walmartInvoiceRelationPOServiceImpl.page(page, Wrappers.query(walmartInvoiceRelationPO)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/walmartinvoicerelationpos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(walmartInvoiceRelationPOServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param walmartInvoiceRelationPO ${table.comment}
   * @return XfR
   */
  @PostMapping("/walmartinvoicerelationpos")
  public XfR save(@RequestBody WalmartInvoiceRelationPO walmartInvoiceRelationPO) {
     return XfR.ok(walmartInvoiceRelationPOServiceImpl.save(walmartInvoiceRelationPO));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param walmartInvoiceRelationPO ${table.comment}
   * @return XfR
   */
  @PutMapping("/walmartinvoicerelationpos/{id}")
  public XfR putUpdate(@RequestBody WalmartInvoiceRelationPO walmartInvoiceRelationPO,@PathVariable Long id) {
      walmartInvoiceRelationPO.setId(id);
      return XfR.ok(walmartInvoiceRelationPOServiceImpl.updateById(walmartInvoiceRelationPO));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param walmartInvoiceRelationPO ${table.comment}
   * @return XfR
   */
  @PatchMapping("/walmartinvoicerelationpos/{id}")
  public XfR patchUpdate(@RequestBody WalmartInvoiceRelationPO walmartInvoiceRelationPO,@PathVariable Long id) {
      WalmartInvoiceRelationPO upwalmartInvoiceRelationPO = walmartInvoiceRelationPOServiceImpl.getById(id);
      if(upwalmartInvoiceRelationPO != null){
        upwalmartInvoiceRelationPO = ObjectCopyUtils.copyProperties(walmartInvoiceRelationPO,upwalmartInvoiceRelationPO,true);
      }
      return XfR.ok(walmartInvoiceRelationPOServiceImpl.updateById(upwalmartInvoiceRelationPO));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/walmartinvoicerelationpos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(walmartInvoiceRelationPOServiceImpl.removeById(id));
  }

  @PostMapping("/walmartinvoicerelationpos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "walmart_invoice_relation_p_o");
     params.put("request", condition);

     return XfR.ok(walmartInvoiceRelationPOServiceImpl.querys(params));
  }

}
