package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.ExpenseBillDetail;
import com.xforceplus.arterydocument.service.IExpenseBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-09
 */
@RestController
public class ExpenseBillDetailController {

  @Autowired
  private IExpenseBillDetailService expenseBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param expenseBillDetail ${table.comment}
   * @return
   */
  @GetMapping("/expensebilldetails" )
  public XfR getExpenseBillDetails(XfPage page, ExpenseBillDetail expenseBillDetail) {
    return XfR.ok(expenseBillDetailServiceImpl.page(page, Wrappers.query(expenseBillDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/expensebilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(expenseBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param expenseBillDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/expensebilldetails")
  public XfR save(@RequestBody ExpenseBillDetail expenseBillDetail) {
     return XfR.ok(expenseBillDetailServiceImpl.save(expenseBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param expenseBillDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/expensebilldetails/{id}")
  public XfR putUpdate(@RequestBody ExpenseBillDetail expenseBillDetail,@PathVariable Long id) {
      expenseBillDetail.setId(id);
      return XfR.ok(expenseBillDetailServiceImpl.updateById(expenseBillDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param expenseBillDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/expensebilldetails/{id}")
  public XfR patchUpdate(@RequestBody ExpenseBillDetail expenseBillDetail,@PathVariable Long id) {
      ExpenseBillDetail upexpenseBillDetail = expenseBillDetailServiceImpl.getById(id);
      if(upexpenseBillDetail != null){
        upexpenseBillDetail = ObjectCopyUtils.copyProperties(expenseBillDetail,upexpenseBillDetail,true);
      }
      return XfR.ok(expenseBillDetailServiceImpl.updateById(upexpenseBillDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/expensebilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(expenseBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/expensebilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "expense_bill_detail");
     params.put("request", condition);

     return XfR.ok(expenseBillDetailServiceImpl.querys(params));
  }

}
