package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.FlowInstanceLog;
import com.xforceplus.arterydocument.service.IFlowInstanceLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 流程实例日志前端控制器
 *
 * @author ultraman
 * @date 2023-08-09
 */
@RestController
public class FlowInstanceLogController {

  @Autowired
  private IFlowInstanceLogService flowInstanceLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param flowInstanceLog 流程实例日志
   * @return
   */
  @GetMapping("/flowinstancelogs" )
  public XfR getFlowInstanceLogs(XfPage page, FlowInstanceLog flowInstanceLog) {
    return XfR.ok(flowInstanceLogServiceImpl.page(page, Wrappers.query(flowInstanceLog)));
  }

  /**
   * 通过id查询流程实例日志
   * @param  id
   * @return XfR
   */
  @GetMapping("/flowinstancelogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(flowInstanceLogServiceImpl.getById(id));
  }

  /**
   * 新增流程实例日志
   * @param flowInstanceLog 流程实例日志
   * @return XfR
   */
  @PostMapping("/flowinstancelogs")
  public XfR save(@RequestBody FlowInstanceLog flowInstanceLog) {
     return XfR.ok(flowInstanceLogServiceImpl.save(flowInstanceLog));
  }

  /**
   * 修改-传入修改后的全部数据流程实例日志
   * @param flowInstanceLog 流程实例日志
   * @return XfR
   */
  @PutMapping("/flowinstancelogs/{id}")
  public XfR putUpdate(@RequestBody FlowInstanceLog flowInstanceLog,@PathVariable Long id) {
      flowInstanceLog.setId(id);
      return XfR.ok(flowInstanceLogServiceImpl.updateById(flowInstanceLog));
  }

  /**
   * 修改-传入修改的数据流程实例日志
   * @param flowInstanceLog 流程实例日志
   * @return XfR
   */
  @PatchMapping("/flowinstancelogs/{id}")
  public XfR patchUpdate(@RequestBody FlowInstanceLog flowInstanceLog,@PathVariable Long id) {
      FlowInstanceLog upflowInstanceLog = flowInstanceLogServiceImpl.getById(id);
      if(upflowInstanceLog != null){
        upflowInstanceLog = ObjectCopyUtils.copyProperties(flowInstanceLog,upflowInstanceLog,true);
      }
      return XfR.ok(flowInstanceLogServiceImpl.updateById(upflowInstanceLog));
  }

  /**
   * 通过id删除流程实例日志
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/flowinstancelogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(flowInstanceLogServiceImpl.removeById(id));
  }

  @PostMapping("/flowinstancelogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "flow_instance_log");
     params.put("request", condition);

     return XfR.ok(flowInstanceLogServiceImpl.querys(params));
  }

}
