package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.CollectionAccountMapping;
import com.xforceplus.arterydocument.service.ICollectionAccountMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-28
 */
@RestController
public class CollectionAccountMappingController {

  @Autowired
  private ICollectionAccountMappingService collectionAccountMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param collectionAccountMapping ${table.comment}
   * @return
   */
  @GetMapping("/collectionaccountmappings" )
  public XfR getCollectionAccountMappings(XfPage page, CollectionAccountMapping collectionAccountMapping) {
    return XfR.ok(collectionAccountMappingServiceImpl.page(page, Wrappers.query(collectionAccountMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/collectionaccountmappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(collectionAccountMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param collectionAccountMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/collectionaccountmappings")
  public XfR save(@RequestBody CollectionAccountMapping collectionAccountMapping) {
     return XfR.ok(collectionAccountMappingServiceImpl.save(collectionAccountMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param collectionAccountMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/collectionaccountmappings/{id}")
  public XfR putUpdate(@RequestBody CollectionAccountMapping collectionAccountMapping,@PathVariable Long id) {
      collectionAccountMapping.setId(id);
      return XfR.ok(collectionAccountMappingServiceImpl.updateById(collectionAccountMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param collectionAccountMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/collectionaccountmappings/{id}")
  public XfR patchUpdate(@RequestBody CollectionAccountMapping collectionAccountMapping,@PathVariable Long id) {
      CollectionAccountMapping upcollectionAccountMapping = collectionAccountMappingServiceImpl.getById(id);
      if(upcollectionAccountMapping != null){
        upcollectionAccountMapping = ObjectCopyUtils.copyProperties(collectionAccountMapping,upcollectionAccountMapping,true);
      }
      return XfR.ok(collectionAccountMappingServiceImpl.updateById(upcollectionAccountMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/collectionaccountmappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(collectionAccountMappingServiceImpl.removeById(id));
  }

  @PostMapping("/collectionaccountmappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "collection_account_mapping");
     params.put("request", condition);

     return XfR.ok(collectionAccountMappingServiceImpl.querys(params));
  }

}
