package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.OrderGoodsManageNum;
import com.xforceplus.arterydocument.service.IOrderGoodsManageNumService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-28
 */
@RestController
public class OrderGoodsManageNumController {

  @Autowired
  private IOrderGoodsManageNumService orderGoodsManageNumServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderGoodsManageNum ${table.comment}
   * @return
   */
  @GetMapping("/ordergoodsmanagenums" )
  public XfR getOrderGoodsManageNums(XfPage page, OrderGoodsManageNum orderGoodsManageNum) {
    return XfR.ok(orderGoodsManageNumServiceImpl.page(page, Wrappers.query(orderGoodsManageNum)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordergoodsmanagenums/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderGoodsManageNumServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderGoodsManageNum ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordergoodsmanagenums")
  public XfR save(@RequestBody OrderGoodsManageNum orderGoodsManageNum) {
     return XfR.ok(orderGoodsManageNumServiceImpl.save(orderGoodsManageNum));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderGoodsManageNum ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordergoodsmanagenums/{id}")
  public XfR putUpdate(@RequestBody OrderGoodsManageNum orderGoodsManageNum,@PathVariable Long id) {
      orderGoodsManageNum.setId(id);
      return XfR.ok(orderGoodsManageNumServiceImpl.updateById(orderGoodsManageNum));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderGoodsManageNum ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordergoodsmanagenums/{id}")
  public XfR patchUpdate(@RequestBody OrderGoodsManageNum orderGoodsManageNum,@PathVariable Long id) {
      OrderGoodsManageNum uporderGoodsManageNum = orderGoodsManageNumServiceImpl.getById(id);
      if(uporderGoodsManageNum != null){
        uporderGoodsManageNum = ObjectCopyUtils.copyProperties(orderGoodsManageNum,uporderGoodsManageNum,true);
      }
      return XfR.ok(orderGoodsManageNumServiceImpl.updateById(uporderGoodsManageNum));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordergoodsmanagenums/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderGoodsManageNumServiceImpl.removeById(id));
  }

  @PostMapping("/ordergoodsmanagenums/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_goods_manage_num");
     params.put("request", condition);

     return XfR.ok(orderGoodsManageNumServiceImpl.querys(params));
  }

}
