package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.PosAndIrCollectionBatchRecord;
import com.xforceplus.arterydocument.service.IPosAndIrCollectionBatchRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-28
 */
@RestController
public class PosAndIrCollectionBatchRecordController {

  @Autowired
  private IPosAndIrCollectionBatchRecordService posAndIrCollectionBatchRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param posAndIrCollectionBatchRecord ${table.comment}
   * @return
   */
  @GetMapping("/posandircollectionbatchrecords" )
  public XfR getPosAndIrCollectionBatchRecords(XfPage page, PosAndIrCollectionBatchRecord posAndIrCollectionBatchRecord) {
    return XfR.ok(posAndIrCollectionBatchRecordServiceImpl.page(page, Wrappers.query(posAndIrCollectionBatchRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/posandircollectionbatchrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(posAndIrCollectionBatchRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param posAndIrCollectionBatchRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/posandircollectionbatchrecords")
  public XfR save(@RequestBody PosAndIrCollectionBatchRecord posAndIrCollectionBatchRecord) {
     return XfR.ok(posAndIrCollectionBatchRecordServiceImpl.save(posAndIrCollectionBatchRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param posAndIrCollectionBatchRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/posandircollectionbatchrecords/{id}")
  public XfR putUpdate(@RequestBody PosAndIrCollectionBatchRecord posAndIrCollectionBatchRecord,@PathVariable Long id) {
      posAndIrCollectionBatchRecord.setId(id);
      return XfR.ok(posAndIrCollectionBatchRecordServiceImpl.updateById(posAndIrCollectionBatchRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param posAndIrCollectionBatchRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/posandircollectionbatchrecords/{id}")
  public XfR patchUpdate(@RequestBody PosAndIrCollectionBatchRecord posAndIrCollectionBatchRecord,@PathVariable Long id) {
      PosAndIrCollectionBatchRecord upposAndIrCollectionBatchRecord = posAndIrCollectionBatchRecordServiceImpl.getById(id);
      if(upposAndIrCollectionBatchRecord != null){
        upposAndIrCollectionBatchRecord = ObjectCopyUtils.copyProperties(posAndIrCollectionBatchRecord,upposAndIrCollectionBatchRecord,true);
      }
      return XfR.ok(posAndIrCollectionBatchRecordServiceImpl.updateById(upposAndIrCollectionBatchRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/posandircollectionbatchrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(posAndIrCollectionBatchRecordServiceImpl.removeById(id));
  }

  @PostMapping("/posandircollectionbatchrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pos_and_ir_collection_batch_record");
     params.put("request", condition);

     return XfR.ok(posAndIrCollectionBatchRecordServiceImpl.querys(params));
  }

}
