package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.PosAndIrTransferDetail;
import com.xforceplus.arterydocument.service.IPosAndIrTransferDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-28
 */
@RestController
public class PosAndIrTransferDetailController {

  @Autowired
  private IPosAndIrTransferDetailService posAndIrTransferDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param posAndIrTransferDetail ${table.comment}
   * @return
   */
  @GetMapping("/posandirtransferdetails" )
  public XfR getPosAndIrTransferDetails(XfPage page, PosAndIrTransferDetail posAndIrTransferDetail) {
    return XfR.ok(posAndIrTransferDetailServiceImpl.page(page, Wrappers.query(posAndIrTransferDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/posandirtransferdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(posAndIrTransferDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param posAndIrTransferDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/posandirtransferdetails")
  public XfR save(@RequestBody PosAndIrTransferDetail posAndIrTransferDetail) {
     return XfR.ok(posAndIrTransferDetailServiceImpl.save(posAndIrTransferDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param posAndIrTransferDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/posandirtransferdetails/{id}")
  public XfR putUpdate(@RequestBody PosAndIrTransferDetail posAndIrTransferDetail,@PathVariable Long id) {
      posAndIrTransferDetail.setId(id);
      return XfR.ok(posAndIrTransferDetailServiceImpl.updateById(posAndIrTransferDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param posAndIrTransferDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/posandirtransferdetails/{id}")
  public XfR patchUpdate(@RequestBody PosAndIrTransferDetail posAndIrTransferDetail,@PathVariable Long id) {
      PosAndIrTransferDetail upposAndIrTransferDetail = posAndIrTransferDetailServiceImpl.getById(id);
      if(upposAndIrTransferDetail != null){
        upposAndIrTransferDetail = ObjectCopyUtils.copyProperties(posAndIrTransferDetail,upposAndIrTransferDetail,true);
      }
      return XfR.ok(posAndIrTransferDetailServiceImpl.updateById(upposAndIrTransferDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/posandirtransferdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(posAndIrTransferDetailServiceImpl.removeById(id));
  }

  @PostMapping("/posandirtransferdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pos_and_ir_transfer_detail");
     params.put("request", condition);

     return XfR.ok(posAndIrTransferDetailServiceImpl.querys(params));
  }

}
