package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.SalesOrder;
import com.xforceplus.arterydocument.service.ISalesOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-28
 */
@RestController
public class SalesOrderController {

  @Autowired
  private ISalesOrderService salesOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesOrder ${table.comment}
   * @return
   */
  @GetMapping("/salesorders" )
  public XfR getSalesOrders(XfPage page, SalesOrder salesOrder) {
    return XfR.ok(salesOrderServiceImpl.page(page, Wrappers.query(salesOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesorders")
  public XfR save(@RequestBody SalesOrder salesOrder) {
     return XfR.ok(salesOrderServiceImpl.save(salesOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesorders/{id}")
  public XfR putUpdate(@RequestBody SalesOrder salesOrder,@PathVariable Long id) {
      salesOrder.setId(id);
      return XfR.ok(salesOrderServiceImpl.updateById(salesOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesorders/{id}")
  public XfR patchUpdate(@RequestBody SalesOrder salesOrder,@PathVariable Long id) {
      SalesOrder upsalesOrder = salesOrderServiceImpl.getById(id);
      if(upsalesOrder != null){
        upsalesOrder = ObjectCopyUtils.copyProperties(salesOrder,upsalesOrder,true);
      }
      return XfR.ok(salesOrderServiceImpl.updateById(upsalesOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesOrderServiceImpl.removeById(id));
  }

  @PostMapping("/salesorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_order");
     params.put("request", condition);

     return XfR.ok(salesOrderServiceImpl.querys(params));
  }

}
