package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.TenantTransferRecord;
import com.xforceplus.arterydocument.service.ITenantTransferRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-28
 */
@RestController
public class TenantTransferRecordController {

  @Autowired
  private ITenantTransferRecordService tenantTransferRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tenantTransferRecord ${table.comment}
   * @return
   */
  @GetMapping("/tenanttransferrecords" )
  public XfR getTenantTransferRecords(XfPage page, TenantTransferRecord tenantTransferRecord) {
    return XfR.ok(tenantTransferRecordServiceImpl.page(page, Wrappers.query(tenantTransferRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tenanttransferrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tenantTransferRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tenantTransferRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/tenanttransferrecords")
  public XfR save(@RequestBody TenantTransferRecord tenantTransferRecord) {
     return XfR.ok(tenantTransferRecordServiceImpl.save(tenantTransferRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tenantTransferRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/tenanttransferrecords/{id}")
  public XfR putUpdate(@RequestBody TenantTransferRecord tenantTransferRecord,@PathVariable Long id) {
      tenantTransferRecord.setId(id);
      return XfR.ok(tenantTransferRecordServiceImpl.updateById(tenantTransferRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tenantTransferRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tenanttransferrecords/{id}")
  public XfR patchUpdate(@RequestBody TenantTransferRecord tenantTransferRecord,@PathVariable Long id) {
      TenantTransferRecord uptenantTransferRecord = tenantTransferRecordServiceImpl.getById(id);
      if(uptenantTransferRecord != null){
        uptenantTransferRecord = ObjectCopyUtils.copyProperties(tenantTransferRecord,uptenantTransferRecord,true);
      }
      return XfR.ok(tenantTransferRecordServiceImpl.updateById(uptenantTransferRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tenanttransferrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tenantTransferRecordServiceImpl.removeById(id));
  }

  @PostMapping("/tenanttransferrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tenant_transfer_record");
     params.put("request", condition);

     return XfR.ok(tenantTransferRecordServiceImpl.querys(params));
  }

}
