package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.SalesOrderDetail;
import com.xforceplus.arterydocument.service.ISalesOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-05
 */
@RestController
public class SalesOrderDetailController {

  @Autowired
  private ISalesOrderDetailService salesOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/salesorderdetails" )
  public XfR getSalesOrderDetails(XfPage page, SalesOrderDetail salesOrderDetail) {
    return XfR.ok(salesOrderDetailServiceImpl.page(page, Wrappers.query(salesOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesorderdetails")
  public XfR save(@RequestBody SalesOrderDetail salesOrderDetail) {
     return XfR.ok(salesOrderDetailServiceImpl.save(salesOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesorderdetails/{id}")
  public XfR putUpdate(@RequestBody SalesOrderDetail salesOrderDetail,@PathVariable Long id) {
      salesOrderDetail.setId(id);
      return XfR.ok(salesOrderDetailServiceImpl.updateById(salesOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesorderdetails/{id}")
  public XfR patchUpdate(@RequestBody SalesOrderDetail salesOrderDetail,@PathVariable Long id) {
      SalesOrderDetail upsalesOrderDetail = salesOrderDetailServiceImpl.getById(id);
      if(upsalesOrderDetail != null){
        upsalesOrderDetail = ObjectCopyUtils.copyProperties(salesOrderDetail,upsalesOrderDetail,true);
      }
      return XfR.ok(salesOrderDetailServiceImpl.updateById(upsalesOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/salesorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_order_detail");
     params.put("request", condition);

     return XfR.ok(salesOrderDetailServiceImpl.querys(params));
  }

}
