package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.SettlementReceiptReturnDetail;
import com.xforceplus.arterydocument.service.ISettlementReceiptReturnDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-05
 */
@RestController
public class SettlementReceiptReturnDetailController {

  @Autowired
  private ISettlementReceiptReturnDetailService settlementReceiptReturnDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementReceiptReturnDetail ${table.comment}
   * @return
   */
  @GetMapping("/settlementreceiptreturndetails" )
  public XfR getSettlementReceiptReturnDetails(XfPage page, SettlementReceiptReturnDetail settlementReceiptReturnDetail) {
    return XfR.ok(settlementReceiptReturnDetailServiceImpl.page(page, Wrappers.query(settlementReceiptReturnDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementreceiptreturndetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementReceiptReturnDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param settlementReceiptReturnDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/settlementreceiptreturndetails")
  public XfR save(@RequestBody SettlementReceiptReturnDetail settlementReceiptReturnDetail) {
     return XfR.ok(settlementReceiptReturnDetailServiceImpl.save(settlementReceiptReturnDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param settlementReceiptReturnDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/settlementreceiptreturndetails/{id}")
  public XfR putUpdate(@RequestBody SettlementReceiptReturnDetail settlementReceiptReturnDetail,@PathVariable Long id) {
      settlementReceiptReturnDetail.setId(id);
      return XfR.ok(settlementReceiptReturnDetailServiceImpl.updateById(settlementReceiptReturnDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param settlementReceiptReturnDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/settlementreceiptreturndetails/{id}")
  public XfR patchUpdate(@RequestBody SettlementReceiptReturnDetail settlementReceiptReturnDetail,@PathVariable Long id) {
      SettlementReceiptReturnDetail upsettlementReceiptReturnDetail = settlementReceiptReturnDetailServiceImpl.getById(id);
      if(upsettlementReceiptReturnDetail != null){
        upsettlementReceiptReturnDetail = ObjectCopyUtils.copyProperties(settlementReceiptReturnDetail,upsettlementReceiptReturnDetail,true);
      }
      return XfR.ok(settlementReceiptReturnDetailServiceImpl.updateById(upsettlementReceiptReturnDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementreceiptreturndetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementReceiptReturnDetailServiceImpl.removeById(id));
  }

  @PostMapping("/settlementreceiptreturndetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_receipt_return_detail");
     params.put("request", condition);

     return XfR.ok(settlementReceiptReturnDetailServiceImpl.querys(params));
  }

}
